/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.validator.prop;

import org.asyrinx.brownie.core.chars.Characters;
import org.asyrinx.brownie.core.chars.impl.StringCharacters;
import org.asyrinx.brownie.validator.prop.AbstractStringField;
import org.asyrinx.brownie.validator.prop.AcceptableCharacters;
import org.asyrinx.brownie.validator.prop.StringFieldCharacterSet;

public class StringFieldToAddChars
extends AbstractStringField {
    private StringFieldCharacterSet acceptedChar = null;
    private StringFieldCharacterSet refusedChar = null;

    public StringFieldToAddChars(String propertyName, String displayName, boolean required, int size) {
        super(propertyName, displayName, required, size);
    }

    protected void prepareValidators() {
        if (this.acceptedChar != null) {
            this.addValidator(new AcceptableCharacters(this.getPropertyName(), this.getDisplayName(), this.acceptedChar));
        }
        if (this.refusedChar != null) {
            this.addValidator(new AcceptableCharacters(this.getPropertyName(), this.getDisplayName(), this.refusedChar, true));
        }
    }

    public void addAcceptable(String value) {
        this.addAcceptable(new StringCharacters(value, value));
    }

    public void addAcceptable(Characters value) {
        if (this.acceptedChar == null) {
            this.acceptedChar = new StringFieldCharacterSet();
        }
        this.acceptedChar.add(value);
    }

    public void addRefused(String value) {
        this.addRefused(new StringCharacters(value, value));
    }

    public void addRefused(Characters value) {
        if (this.refusedChar == null) {
            this.refusedChar = new StringFieldCharacterSet();
        }
        this.refusedChar.add(value);
    }
}

