/*
 * joey-rt and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2005/02/20 17:06:22
 */
package org.asyrinx.joey.entity.dictionary.impl;

import org.asyrinx.brownie.core.query.exp.IExpression;
import org.asyrinx.brownie.core.query.model.Table;
import org.asyrinx.joey.entity.dictionary.ConditionBuilder;
import org.asyrinx.joey.entity.dictionary.ConditionBuilderDictionary;
import org.asyrinx.joey.entity.dictionary.EntityMappingDictionary;

/**
 * @author takeshi
 */
public class BasicMappingDictionary implements ConditionBuilderDictionary, EntityMappingDictionary {

    public IExpression execute(Class entityClass, Object bean) {
        final ConditionBuilder builder = getBuilder(entityClass);
        return builder.execute(bean);
    }

    public ConditionBuilder getBuilder(Class entityClass) {
        return builderDictionary.getBuilder(entityClass);
    }

    public Table getMapping(Class entityClass) {
        return mappingDictionary.getMapping(entityClass);
    }

    public void put(Class entityClass, Table table) {
        mappingDictionary.put(entityClass, table);
        final ConditionBuilder builder = new ConditionBuilderImpl(table);
        builderDictionary.put(entityClass, builder);
    }

    protected ConditionBuilderDictionaryImpl builderDictionary = new ConditionBuilderDictionaryImpl();

    protected EntityMappingDictionaryImpl mappingDictionary = new EntityMappingDictionaryImpl();

}