/*
 * joey-rt and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2005/02/20 15:32:44
 */
package org.asyrinx.joey.entity.dictionary.impl;

import org.asyrinx.brownie.core.collection.ClassKeyHashMap;
import org.asyrinx.brownie.core.collection.ClassKeyMap;
import org.asyrinx.brownie.core.query.exp.IExpression;
import org.asyrinx.joey.entity.dictionary.ConditionBuilder;
import org.asyrinx.joey.entity.dictionary.ConditionBuilderDictionary;

/**
 * @author takeshi
 */
public class ConditionBuilderDictionaryImpl implements ConditionBuilderDictionary {

    private final ClassKeyMap classKeyMap = new ClassKeyHashMap();

    public void put(Class entityClass, ConditionBuilder builder) {
        classKeyMap.put(entityClass, builder);
    }

    public ConditionBuilder getBuilder(Class entityClass) {
        return (ConditionBuilder) classKeyMap.get(entityClass);
    }

    public IExpression execute(Class entityClass, Object bean) {
        final ConditionBuilder builder = getBuilder(entityClass);
        return builder.execute(bean);
    }
}