/*
 * joey-sample1 and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2005/02/07 21:52:43
 */
package org.asyrinx.joey.entity.service;

import org.asyrinx.brownie.validator.MessageLevel;
import org.asyrinx.brownie.validator.ValidationContext;
import org.asyrinx.brownie.validator.ValidationContextFactory;
import org.asyrinx.brownie.validator.Validator;
import org.asyrinx.joey.exception.AppValidationException;
import org.asyrinx.joey.exception.AppValidationRuntimeException;

/**
 * @author takeshi
 */
public abstract class AbstractEntityService implements EntityService {

    /**
     *  
     */
    public AbstractEntityService() {
        super();
    }

    public abstract Class getEntityClass();

    private MessageLevel exceptionLevel = MessageLevel.ERROR;

    public void validate(Object obj) throws AppValidationException {
        final ValidationContext context = createValidationContext();
        validate(obj, context);
        if (!context.getMatters().isEmpty())
            throw new AppValidationException(context);
    }

    /**
     * @param obj
     * @param context
     */
    public void validate(Object obj, ValidationContext context) {
        validateByValidator(context, obj);
        validateUnique(context, obj);
    }

    /**
     * @param obj
     * @param context
     */
    public void validateByValidator(ValidationContext context, Object obj) {
        final ValidatorDictionary dictionary = getValidatorDictionary();
        for (Class current = obj.getClass(); current != null; current = current.getSuperclass()) {
            final Validator validator = dictionary.getValidator(current);
            if (validator != null)
                validator.evaluate(context, obj);
        }
    }

    /**
     * @param obj
     * @param context
     */
    public abstract void validateUnique(ValidationContext context, Object obj);

    /**
     * @param obj
     * @param context
     */
    public boolean checkUnique(Object obj) {
        final ValidationContext context = createValidationContext();
        validateUnique(context, obj);
        return context.getMessages().isEmpty();
    }

    /**
     * @return
     */
    protected ValidationContext createValidationContext() {
        return getValidationContextFactory().createContext();
    }

    private ValidatorDictionary validatorDictionary = null;

    public ValidatorDictionary getValidatorDictionary() {
        return validatorDictionary;
    }

    public void setValidatorDictionary(ValidatorDictionary validatorDictionary) {
        this.validatorDictionary = validatorDictionary;
    }

    private boolean validateBeforeSave = true;

    public boolean isValidateBeforeSave() {
        return validateBeforeSave;
    }

    public void setValidateBeforeSave(boolean validateBeforeSave) {
        this.validateBeforeSave = validateBeforeSave;
    }

    protected void doBeforeSave(Object obj) {
        if (!this.isValidateBeforeSave())
            return;
        try {
            this.validate(obj);
        } catch (AppValidationException e) {
            throw new AppValidationRuntimeException(e.getContext(), e);
        }
    }

    public MessageLevel getExceptionLevel() {
        return exceptionLevel;
    }

    public void setExceptionLevel(MessageLevel exceptionLevel) {
        this.exceptionLevel = exceptionLevel;
    }

    private ValidationContextFactory validationContextFactory = null;

    public ValidationContextFactory getValidationContextFactory() {
        return validationContextFactory;
    }

    public void setValidationContextFactory(ValidationContextFactory validationContextFactory) {
        this.validationContextFactory = validationContextFactory;
    }
}