/*
 * joey-sample1 and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2005/02/08 14:55:42
 */
package org.asyrinx.joey.entity.service;

import org.asyrinx.brownie.validator.MessageLevel;
import org.asyrinx.brownie.validator.ValidationContext;
import org.asyrinx.joey.exception.AppValidationException;

/**
 * @author takeshi
 */
public interface EntityService {

    Class getEntityClass();

    boolean checkUnique(Object obj);

    void validate(Object obj) throws AppValidationException;

    void validate(Object obj, ValidationContext context);

    void validateByValidator(ValidationContext context, Object obj);

    void validateUnique(ValidationContext context, Object obj);

    boolean isValidateBeforeSave();

    void setValidateBeforeSave(boolean validateBeforeSave);

    MessageLevel getExceptionLevel();

    void setExceptionLevel(MessageLevel exceptionLevel);

}