/*
 * joey-rt and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/12/27 15:10:00
 */
package org.asyrinx.joey.entity.service.aspect;

import java.util.Date;

import org.aopalliance.intercept.MethodInvocation;
import org.asyrinx.joey.entity.service.util.EntityDateUtils;
import org.seasar.framework.aop.interceptors.AbstractInterceptor;

/**
 * @author takeshi
 */
public class CreatedDateInterceptor extends AbstractInterceptor {

    public CreatedDateInterceptor(String propertyName) {
        this.propertyName = propertyName;
    }

    private final String propertyName;

    public Object invoke(MethodInvocation invocation) throws Throwable {
        final Object[] args = invocation.getArguments();
        if (args.length != 1)
            throw new UnsupportedOperationException("arguments must be one");
        final Object object = args[0];
        EntityDateUtils.setCreatedDate(object, this.propertyName, new Date());
        return invocation.proceed();
    }

}