/*
 * joey-rt and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/12/27 15:10:00
 */
package org.asyrinx.joey.entity.service.aspect;

import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.asyrinx.brownie.core.lang.UnsupportedClassRuntimeException;
import org.asyrinx.brownie.core.lang.enum.util.BooleanEnum;
import org.seasar.framework.aop.interceptors.AbstractInterceptor;

/**
 * @author takeshi
 */
public class LogicallyDeletableSaveInterceptor extends AbstractInterceptor {

    public LogicallyDeletableSaveInterceptor(String propertyName) {
        this.propertyName = propertyName;
    }

    private final String propertyName;

    public Object invoke(MethodInvocation invocation) throws Throwable {
        final Object dao = PropertyUtils.getProperty(invocation.getThis(), "mainDao");
        if (dao == null)
            throw new UnsupportedClassRuntimeException("service '"
                    + invocation.getThis().getClass().getName() + "' has no mainDao.");
        final Object[] args = invocation.getArguments();
        if (args.length != 1)
            throw new UnsupportedOperationException("arguments must be one");
        final Object object = args[0];
        PropertyUtils.setProperty(object, this.propertyName, new Integer(BooleanEnum.toInt(true)));
        return MethodUtils.invokeMethod(dao, "save", object);
    }

}