/*
 * joey-rt and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/12/12 1:01:02
 */
package org.asyrinx.joey.entity.service.impl;

import java.io.Serializable;
import java.util.List;

import org.apache.commons.beanutils.MethodUtils;
import org.asyrinx.brownie.core.query.exp.IExpression;
import org.asyrinx.joey.entity.service.EntityServiceDictionary;
import org.asyrinx.joey.entity.service.EntityServiceDispatcher;
import org.asyrinx.joey.entity.service.EntityServiceException;

/**
 * @author takeshi
 */
public class EntityServiceDispatcherImpl implements EntityServiceDispatcher {

    /**
     *  
     */
    public EntityServiceDispatcherImpl(EntityServiceDictionary serviceDictionary) {
        super();
        this.serviceDictionary = serviceDictionary;
    }

    public void delete(Object entity) {
        delete(entity.getClass(), entity);
    }

    public void save(Object entity) {
        save(entity.getClass(), entity);
    }

    public void insert(Object entity) {
        insert(entity.getClass(), entity);
    }

    public void insert(Object entity, Serializable id) {
        insert(entity.getClass(), entity, id);
    }

    public void update(Object entity) {
        update(entity.getClass(), entity);
    }

    public void update(Object entity, Serializable id) {
        update(entity.getClass(), entity, id);
    }

    public void delete(Class entityClass, Object entity) {
        invokeServiceMethod(entityClass, "delete", entity);
    }

    public void save(Class entityClass, Object entity) {
        invokeServiceMethod(entityClass, "save", entity);
    }

    public void insert(Class entityClass, Object entity) {
        invokeServiceMethod(entityClass, "insert", entity);
    }

    public void insert(Class entityClass, Object entity, Serializable id) {
        invokeServiceMethod(entityClass, "insert", entity, id);
    }

    public void update(Class entityClass, Object entity) {
        invokeServiceMethod(entityClass, "update", entity);
    }

    public void update(Class entityClass, Object entity, Serializable id) {
        invokeServiceMethod(entityClass, "update", entity, id);
    }

    public Object load(Class entityClass, Serializable key) {
        return invokeServiceMethod(entityClass, "load", key);
    }

    public Object get(Class entityClass, Serializable key) {
        return invokeServiceMethod(entityClass, "get", key);
    }

    public List select(Class entityClass, IExpression condition) {
        final Object result = invokeServiceMethod(entityClass, "select", condition,
                IExpression.class);
        if (!(result instanceof List))
            throw new EntityServiceException("");
        return (List) result;
    }

    private final EntityServiceDictionary serviceDictionary;

    public Object getService(Class entityClass) {
        return serviceDictionary.getService(entityClass);
    }

    /**
     * @param entityClass
     * @param methodName
     * @param param
     */
    private Object invokeServiceMethod(Class entityClass, String methodName, Object param) {
        final Object service = getService(entityClass);
        try {
            return MethodUtils.invokeMethod(service, methodName, param);
        } catch (Exception e) {
            throw toRuntimeException(e);
        }
    }

    /**
     * @param entityClass
     * @param methodName
     * @param param
     */
    private Object invokeServiceMethod(Class entityClass, String methodName, Object entity,
            Serializable id) {
        return invokeServiceMethod(entityClass, methodName, new Object[] { entity, id },
                new Class[] { entity.getClass(), Serializable.class });
    }

    /**
     * @param entityClass
     * @param methodName
     * @param param
     */
    private Object invokeServiceMethod(Class entityClass, String methodName, Object param,
            Class paramClass) {
        return invokeServiceMethod(entityClass, methodName, new Object[] { param },
                new Class[] { paramClass });
    }

    /**
     * @param entityClass
     * @param methodName
     * @param param
     */
    private Object invokeServiceMethod(Class entityClass, String methodName, Object[] params,
            Class[] paramClasses) {
        final Object service = getService(entityClass);
        try {
            return MethodUtils.invokeMethod(service, methodName, params, paramClasses);
        } catch (Exception e) {
            throw toRuntimeException(e);
        }
    }

    /**
     * @param e
     * @return
     */
    private RuntimeException toRuntimeException(Exception e) {
        if (e instanceof RuntimeException)
            return (RuntimeException) e;
        if (e.getCause() instanceof RuntimeException)
            return (RuntimeException) e.getCause();
        return new EntityServiceException((e.getCause() == null) ? e : e.getCause());
    }

}