/*
 * joey-rt and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2005/02/07 16:28:47
 */
package org.asyrinx.joey.exception;

import org.asyrinx.brownie.validator.ValidationContext;

/**
 * @author takeshi
 */
public class AppValidationRuntimeException extends AppRuntimeException implements ValidationNotification {

    /**
     *  
     */
    public AppValidationRuntimeException() {
        this((ValidationContext) null);
    }

    /**
     * @param msg
     */
    public AppValidationRuntimeException(String msg) {
        this(null, msg);
    }

    /**
     * @param cause
     */
    public AppValidationRuntimeException(Throwable cause) {
        this((ValidationContext) null, cause);
    }

    /**
     * @param msg
     * @param cause
     */
    public AppValidationRuntimeException(String msg, Throwable cause) {
        this(null, msg, cause);
    }

    /**
     * @param context
     */
    public AppValidationRuntimeException(ValidationContext context) {
        super();
        this.context = context;
    }

    /**
     * @param context
     * @param msg
     */
    public AppValidationRuntimeException(ValidationContext context, String msg) {
        super(msg);
        this.context = context;
    }

    /**
     * @param context
     * @param cause
     */
    public AppValidationRuntimeException(ValidationContext context, Throwable cause) {
        super(cause);
        this.context = context;
    }

    /**
     * @param context
     * @param msg
     * @param cause
     */
    public AppValidationRuntimeException(ValidationContext context, String msg, Throwable cause) {
        super(msg, cause);
        this.context = context;
    }

    protected final ValidationContext context;

    public ValidationContext getContext() {
        return context;
    }
}