/*
 * joey-rt and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/12/14 13:59:33
 */
package org.asyrinx.joey.exception;

import org.apache.commons.lang.exception.NestableRuntimeException;

/**
 * @author takeshi
 */
public class ConfigurationException extends NestableRuntimeException {

    /**
     * @param phenomenon
     * @param correspondense
     */
    public ConfigurationException(String phenomenon, String correspondense) {
        super();
        this.phenomenon = phenomenon;
        this.correspondense = correspondense;
    }

    /**
     * @param phenomenon
     * @param correspondense
     * @param cause
     */
    public ConfigurationException(String phenomenon, String correspondense, Throwable cause) {
        super(cause);
        this.phenomenon = phenomenon;
        this.correspondense = correspondense;
    }

    private final String phenomenon;

    private final String correspondense;

    /*
     * (non-Javadoc)
     * 
     * @see org.apache.commons.lang.exception.NestableRuntimeException#getMessage()
     */
    public String getMessage() {
        return "phenomenon: \n" + phenomenon + "\ncorrespondense: \n" + correspondense;
    }

    public String getCorrespondense() {
        return correspondense;
    }

    public String getPhenomenon() {
        return phenomenon;
    }
}