/*
 * joey-sample1 and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/12/08 8:31:59
 */
package org.asyrinx.joey.s2hibernate.filter.impl;

import org.asyrinx.joey.s2hibernate.filter.S2SessionFactorySurrogate;
import org.seasar.hibernate.S2Session;

/**
 * @author takeshi
 */
public class S2SessionFactorySurrogateImpl implements S2SessionFactorySurrogate {

    public S2SessionFactorySurrogateImpl() {
        super();
    }

    private S2Session session = null;

    public S2Session getSession() {
        return this.session;
    }

    public void openSession(S2Session session) {
        this.session = session;
        if (isClearAfterOpen())
            this.session.clear();
    }

    public void closeSession() {
        if (isFlushBeforeClose())
            this.session.flush();
        if (isClearBeforeClose())
            this.session.clear();
        this.session.close();
        this.session = null;
    }

    private boolean clearAfterOpen = false;

    private boolean clearBeforeClose = false;

    private boolean flushBeforeClose = false;

    public boolean isClearAfterOpen() {
        return clearAfterOpen;
    }

    public void setClearAfterOpen(boolean clearAfterOpen) {
        this.clearAfterOpen = clearAfterOpen;
    }

    public boolean isClearBeforeClose() {
        return clearBeforeClose;
    }

    public void setClearBeforeClose(boolean clearBeforeClose) {
        this.clearBeforeClose = clearBeforeClose;
    }

    public boolean isFlushBeforeClose() {
        return flushBeforeClose;
    }

    public void setFlushBeforeClose(boolean flushBeforeClose) {
        this.flushBeforeClose = flushBeforeClose;
    }
}