/*
 * joey-rt and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/12/13 2:21:32
 */
package org.asyrinx.joey.tapestry.components.entity;

import org.apache.tapestry.ApplicationRuntimeException;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IPage;
import org.apache.tapestry.IRequestCycle;
import org.asyrinx.brownie.tapestry.page.ReloadablePage;
import org.asyrinx.joey.entity.Orphanable;

/**
 * @author takeshi
 */
public abstract class EntityDeletionLink extends AbstractEntityInstanceActionLink {

    protected void doAction(IRequestCycle cycle) {
        final Object entity = deserialize(cycle);
        if (entity instanceof Orphanable)
            ((Orphanable) entity).beOrphaned();
        try {
            getDispatcher().delete(entity);
        } catch (Throwable e) {
            throw new ApplicationRuntimeException(e);
        }
        //
        final IPage page = cycle.getPage();
        if (page instanceof ReloadablePage) {
            final ReloadablePage reloadablePage = (ReloadablePage) page;
            reloadablePage.reload();
        }
        cycle.activate(page);
    }

    private static final String KEY_RENDERED_SCRIPT = EntityDeletionLink.class.getName()
            + ".renderedScript";

    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) {
        this.renderScript = getRenderScriptFlag(cycle);
        super.renderComponent(writer, cycle);
        cycle.setAttribute(KEY_RENDERED_SCRIPT, new Boolean(false));
    }

    /**
     * @param cycle
     */
    private boolean getRenderScriptFlag(IRequestCycle cycle) {
        final Object renderScriptObj = cycle.getAttribute(KEY_RENDERED_SCRIPT);
        final Boolean b = (renderScriptObj == null) ? new Boolean(true)
                : (renderScriptObj instanceof Boolean) ? (Boolean) renderScriptObj : new Boolean(
                        true);
        return b.booleanValue();
    }

    private boolean renderScript = true;

    public boolean isRenderScript() {
        return renderScript;
    }
}