/*
 * joey-sample1 and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2005/01/22 18:23:02
 */
package org.asyrinx.joey.tapestry.components.entity.subwindow;

import java.util.HashMap;
import java.util.Map;

import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tapestry.ApplicationRuntimeException;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.form.IFormComponent;
import org.apache.tapestry.valid.IValidator;
import org.asyrinx.brownie.core.lang.NumberUtils;

/**
 * @author takeshi
 */
public abstract class EntityReference extends BaseComponent implements IEntityReference {

    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) {
        if (getValidator() == null) {
            final IValidator validator = createValidator(getEntityIdType());
            this.setValidator(validator);
        }
        super.renderComponent(writer, cycle);
    }

    final Log log = LogFactory.getLog(this.getClass());

    private IValidator createValidator(String idTypeName) {
        if ("String".equals(idTypeName)) {
            return new StringValidator();
        } else {
            final Class typeClass = (Class) type2Class.get(idTypeName);
            if (typeClass == null)
                throw new UnsupportedOperationException("unsupported type '" + idTypeName + "'");
            return new NumberValidator(typeClass);
        }
    }

    public String getEntityCaption() {
        final Object bean = getBean();
        if (bean == null)
            return null;
        final Object caption;
        try {
            caption = PropertyUtils.getProperty(bean, getCaptionProperty());
            return (caption == null) ? null : caption.toString();
        } catch (Exception e) {
            throw new ApplicationRuntimeException("failed to get caption '" + getCaptionProperty()
                    + "'", e);
        }
    }

    public String getIdSpanStyle() {
        return isVisibleId() ? "display:inline" : "display:none";
    }

    public Map getFieldMapping() {
        final Map result = new HashMap();
        result.put(getEntityCaptionComponentId(), getCaptionProperty());
        result.put(getEntityIdComponentId(), getIdProperty());
        return result;
    }

    public String getEntityCaptionComponentId() {
        return getId() + COMPONENT_ID_ENTITY_CAPTION;
    }

    public String getEntityIdComponentId() {
        return getId() + COMPONENT_ID_ENTITY_ID;
    }

    public String getClearLinkId() {
        return getId() + COMPONENT_ID_CLEAR;
    }

    public Map getSymbols() {
        final Map result = new HashMap();
        result.put("entityCaptionComponentId", getEntityCaptionComponentId());
        result.put("entityIdComponentId", getEntityIdComponentId());
        result.put("clearLinkId", getClearLinkId());
        return result;
    }

    private static final String COMPONENT_ID_ENTITY_ID = "id_entity_id";

    private static final String COMPONENT_ID_ENTITY_CAPTION = "id_entity_caption";

    private static final String COMPONENT_ID_CLEAR = "id_entity_clear";

    private static final Map type2Class = initType2Map();

    /**
     * @return
     */
    private static Map initType2Map() {
        final Map result = new HashMap();
        result.put("byte", Byte.class);
        result.put("short", Short.class);
        result.put("int", Integer.class);
        result.put("long", Long.class);
        result.put("float", Float.class);
        result.put("double", Double.class);
        result.put("Byte", Byte.class);
        result.put("Short", Short.class);
        result.put("Integer", Integer.class);
        result.put("Long", Long.class);
        result.put("Float", Float.class);
        result.put("Double", Double.class);
        return result;
    }

    private boolean visibleId = true;

    /**
     * @return Returns the visibleId.
     */
    public boolean isVisibleId() {
        return visibleId;
    }

    /**
     * @param visibleId
     *            The visibleId to set.
     */
    public void setVisibleId(boolean visibleId) {
        this.visibleId = visibleId;
    }
}

class NumberValidator implements IValidator {
    public NumberValidator(Class numberClass) {
        this.numberClass = numberClass;
    }

    private final Class numberClass;

    public boolean isRequired() {
        return false;
    }

    public void renderValidatorContribution(IFormComponent field, IMarkupWriter writer,
            IRequestCycle cycle) {
        //do nothing
    }

    public Object toObject(IFormComponent field, String input) {
        if (StringUtils.isEmpty(input))
            return null;
        return NumberUtils.toNumber(input, numberClass);
    }

    public String toString(IFormComponent field, Object value) {
        return (value == null) ? null : value.toString();
    }

}

class StringValidator implements IValidator {
    public boolean isRequired() {
        return false;
    }

    public void renderValidatorContribution(IFormComponent field, IMarkupWriter writer,
            IRequestCycle cycle) {
        //do nothing
    }

    public Object toObject(IFormComponent field, String input) {
        return input;
    }

    public String toString(IFormComponent field, Object value) {
        return (value == null) ? null : value.toString();
    }

}