/*
 * joey-rt-test and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/12/15 10:56:17
 */
package org.asyrinx.joey.tapestry.components.entity.table.impl;

import java.util.Iterator;

import org.apache.tapestry.ApplicationRuntimeException;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.asyrinx.brownie.tapestry.seasar.S2BaseComponent;
import org.asyrinx.joey.tapestry.components.entity.table.IListTable;
import org.asyrinx.joey.tapestry.components.entity.table.IListTableColumn;
import org.asyrinx.joey.tapestry.components.entity.table.IListTableRow;

/**
 * @author takeshi
 */
public abstract class AbstractListTableRow extends S2BaseComponent implements IListTableRow {

    protected void finishLoad() {
        setElement("tr");
    }

    private static final String ATTRIBUTE_NAME = "org.apache.tapestry.active.ListTableRow";

    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) {
        final ListTable table = ListTable.get(cycle);
        if (table == null)
            throw new ApplicationRuntimeException("ListTableRow may not be used without ListTable");
        setTable(table);
        renderRow(writer, cycle);
    }

    protected void renderRow(IMarkupWriter writer, IRequestCycle cycle) {
        final IMarkupWriter nested = writer.getNestedWriter();
        renderCol(nested, cycle);
        writer.println();
        writer.begin(getElement());
        renderInformalParameters(writer, cycle);
        writer.println();
        nested.close();
        writer.end();
    }

    protected void renderCol(IMarkupWriter writer, IRequestCycle cycle) {
        final IListTable table = getTable();
        for (Iterator i = table.getColumns().iterator(); i.hasNext();) {
            final IListTableColumn columnDef = (IListTableColumn) i.next();
            setColumn(columnDef);
            columnDef.renderCell(writer, cycle, this);
        }
    }

    public void renderCellContent(IMarkupWriter writer, IRequestCycle cycle) {
        super.renderComponent(writer, cycle);
    }

    public static AbstractListTableRow get(IRequestCycle cycle) {
        return (AbstractListTableRow) cycle.getAttribute(ATTRIBUTE_NAME);
    }

    private IListTable table = null;

    private IListTableColumn column = null;

    private String element = null;

    private String cellElement = null;

    public String getCellElement() {
        return cellElement;
    }

    public void setCellElement(String cellElement) {
        this.cellElement = cellElement;
    }

    public IListTableColumn getColumn() {
        return column;
    }

    public void setColumn(IListTableColumn column) {
        this.column = column;
    }

    public String getElement() {
        return element;
    }

    public void setElement(String element) {
        this.element = element;
    }

    public IListTable getTable() {
        return table;
    }

    public void setTable(IListTable table) {
        this.table = table;
    }

}