/*
 * joey-rt and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2005/01/24 18:13:16
 */
package org.asyrinx.joey.tapestry.page.impl;

import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.asyrinx.brownie.core.lang.UnsupportedClassRuntimeException;
import org.asyrinx.joey.tapestry.page.DetailView;
import org.asyrinx.joey.tapestry.valid.ValidatorFactory;

/**
 * @author takeshi
 */
public abstract class BaseEditComponent extends BaseComponent implements DetailView {

    public abstract Class getTargetClass();

    public abstract ValidatorFactory getValidatorFactory();

    /*
     * (non-Javadoc)
     * 
     * @see org.apache.tapestry.BaseComponent#renderComponent(org.apache.tapestry.IMarkupWriter,
     *      org.apache.tapestry.IRequestCycle)
     */
    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) {
        checkTarget(getTarget());
        super.renderComponent(writer, cycle);
    }

    private void checkTarget(Object bean) {
        final Class class1 = getTargetClass();
        if (class1 == null)
            return;
        if (!class1.isInstance(bean))
            throw new UnsupportedClassRuntimeException("Illegal target bean. Target must be '"
                    + class1.getName() + "': bean + " + bean);
    }

    private Object targetObject = null;

    public Object getTargetObject() {
        return this.targetObject;
    }

    public void setTargetObject(Object bean) {
        this.targetObject = bean;
    }

    public Object getTarget() {
        return getTargetObject();
    }

    public void setTarget(Object bean) {
        setTargetObject(bean);
    }

}