/*
 * joey-rt and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/12/13 4:48:27
 */
package org.asyrinx.joey.tapestry.page.impl;

import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.ApplicationRuntimeException;
import org.apache.tapestry.IPage;
import org.apache.tapestry.IRequestCycle;
import org.asyrinx.joey.tapestry.page.DetailView;
import org.asyrinx.joey.tapestry.page.EntityPageDictionary;
import org.asyrinx.joey.tapestry.page.IEntityPagingComponent;
import org.asyrinx.joey.tapestry.page.IEntityPagingStrategy;

/**
 * @author takeshi
 */
public class EntityPagingStrategyImpl implements IEntityPagingStrategy {

    /**
     *  
     */
    public EntityPagingStrategyImpl(IEntityPagingComponent action) {
        super();
        this.action = action;
    }

    private final IEntityPagingComponent action;

    private EntityPageDictionary pageDictionary = null;

    public EntityPageDictionary getPageDictionary() {
        EntityPageDictionary result = action.getDetailPageDictionary();
        if (result != null)
            return result;
        if (this.pageDictionary != null)
            return this.pageDictionary;
        if (!StringUtils.isEmpty(action.getDetailPageDictionaryName())) {
            result = (EntityPageDictionary) action.getS2Container().getComponent(action.getDetailPageDictionaryName());
            if (result != null)
                return result;
        }
        result = (EntityPageDictionary) action.getS2Container().getComponent(EntityPageDictionary.class);
        if (result == null)
            throw new ApplicationRuntimeException("Component was not found. '" + action.getDetailPageDictionaryName()
                    + "'.");
        return result;
    }

    /**
     * @param entity
     * @return
     */
    public String getDetailPageName(Object entity) {
        if (!StringUtils.isEmpty(action.getDetailPageName()))
            return action.getDetailPageName();
        final String pageName = getPageDictionary().getPageName(entity.getClass());
        if (StringUtils.isEmpty(pageName))
            throw new ApplicationRuntimeException("Page was not found for entity '" + entity.getClass().getName()
                    + "'.");
        return pageName;
    }

    /**
     * @param cycle
     * @param entity
     */
    public void showEntity(IRequestCycle cycle, Object entity) {
        final String pageName = getDetailPageName(entity);
        //
        final IPage page = cycle.getPage(pageName);
        if (page == null)
            throw new ApplicationRuntimeException("Page was not found. '" + pageName + "'.");
        if (page instanceof DetailView) {
            final DetailView detailView = (DetailView) page;
            detailView.setTargetObject(entity);
        }
        cycle.activate(page);
    }
}