/*
 * joey-sample1 and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2005/02/11 15:40:15
 */
package org.asyrinx.joey.tapestry.valid.impl;

import java.util.Iterator;

import org.apache.tapestry.valid.IValidator;
import org.asyrinx.brownie.tapestry.valid.StringFieldValidator;
import org.asyrinx.brownie.validator.ValidationContextFactory;
import org.asyrinx.brownie.validator.Validator;
import org.asyrinx.brownie.validator.ValidatorRuntimeException;
import org.asyrinx.brownie.validator.impl.CompositeValidator;
import org.asyrinx.brownie.validator.prop.PropertyValidator;
import org.asyrinx.brownie.validator.prop.StringField;
import org.asyrinx.joey.entity.service.ValidatorDictionary;
import org.asyrinx.joey.tapestry.valid.ValidatorFactory;

/**
 * @author takeshi
 */
public class ValidatorFactoryImpl implements ValidatorFactory {

    /**
     *  
     */
    public ValidatorFactoryImpl(ValidatorDictionary dictionary,
            ValidationContextFactory contextFactory) {
        super();
        this.dictionary = dictionary;
        this.contextFactory = contextFactory;
    }

    private final ValidatorDictionary dictionary;

    private final ValidationContextFactory contextFactory;

    public IValidator getValidator(Class entityClass, String propertyName) {
        final PropertyValidator propValidator = getPropertyValidator(entityClass, propertyName);
        if (propValidator == null)
            throw createNotFound(entityClass, propertyName);
        if (propValidator instanceof StringField) {
            return createStringFieldValidator((StringField) propValidator);
        }
        throw createNotFound(entityClass, propertyName);
    }

    /**
     * @param stringField
     * @return
     */
    private StringFieldValidator createStringFieldValidator(StringField stringField) {
        final StringFieldValidator result = new StringFieldValidator(stringField);
        result.setContextFactory(this.contextFactory);
        result.setCheckOnBlur(this.isCheckOnBlur());
        result.setCheckOnSubmit(this.isCheckOnSubmit());
        return result;
    }

    /**
     * @param entityClass
     * @param propertyName
     * @return
     */
    private ValidatorRuntimeException createNotFound(Class entityClass, String propertyName) {
        return new ValidatorRuntimeException("validator not fount for " + entityClass.getName()
                + "#" + propertyName);
    }

    /**
     * @param entityClass
     * @param propertyName
     */
    private PropertyValidator getPropertyValidator(Class entityClass, String propertyName) {
        final Validator validator = dictionary.getValidator(entityClass);
        if (validator == null)
            return null;
        if (validator instanceof PropertyValidator)
            return (PropertyValidator) validator;
        if (!(validator instanceof CompositeValidator))
            return null;
        final CompositeValidator compositeValidator = (CompositeValidator) validator;
        for (Iterator i = compositeValidator.iterator(); i.hasNext();) {
            final Validator v = (Validator) i.next();
            if (!(v instanceof PropertyValidator))
                continue;
            final PropertyValidator sf = (PropertyValidator) v;
            if (sf.getPropertyName().equals(propertyName))
                return sf;
        }
        return null;
    }

    private boolean checkOnBlur = false;

    private boolean checkOnSubmit = true;

    public boolean isCheckOnBlur() {
        return checkOnBlur;
    }

    public void setCheckOnBlur(boolean checkOnBlur) {
        this.checkOnBlur = checkOnBlur;
    }

    public boolean isCheckOnSubmit() {
        return checkOnSubmit;
    }

    public void setCheckOnSubmit(boolean checkOnSubmit) {
        this.checkOnSubmit = checkOnSubmit;
    }
}