/*
 * joey-rt and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2005/02/18 16:26:34
 */
package test.org.asyrinx.joey.entity.dictionary.impl;

import java.util.Date;

import org.apache.commons.lang.math.NumberRange;
import org.asyrinx.brownie.core.query.exp.ICompositeExpression;
import org.asyrinx.brownie.core.query.exp.IExpression;
import org.asyrinx.brownie.core.query.exp.IFieldValuedExpression;
import org.asyrinx.brownie.core.query.model.Field;
import org.asyrinx.brownie.core.query.model.Table;
import org.asyrinx.brownie.core.util.DateRangeMutable;
import org.asyrinx.joey.entity.dictionary.ConditionBuilder;
import org.asyrinx.joey.entity.dictionary.impl.ConditionBuilderImpl;

import junit.framework.TestCase;

/**
 * @author takeshi
 */
public class ConditionBuilderImplTest extends TestCase {

    public static void main(String[] args) {
        junit.swingui.TestRunner.run(ConditionBuilderImplTest.class);
    }

    public static class TestEntity {
        //
    }

    public static final Table T1 = new Table("test_model_1",
            "test.org.asyrinx.joey.entity.dictionary.impl.ConditionBuilderImplTest.TestEntity");

    public static final Field T1_F1 = new Field(T1, int.class, "int_field", "intField");

    public static final Field T1_F2 = new Field(T1, long.class, "long_field", "longField");

    public static final Field T1_F3 = new Field(T1, String.class, "string_field", "stringField");

    public static final Field T1_F4 = new Field(T1, Date.class, "date_field", "dateField");

    public static class TestCondition {
        private String stringField = null;

        private DateRangeMutable dateField = null;

        private NumberRange intField = null;

        public DateRangeMutable getDateField() {
            return dateField;
        }

        public void setDateField(DateRangeMutable dateField) {
            this.dateField = dateField;
        }

        public NumberRange getIntField() {
            return intField;
        }

        public void setIntField(NumberRange intField) {
            this.intField = intField;
        }

        public String getStringField() {
            return stringField;
        }

        public void setStringField(String stringField) {
            this.stringField = stringField;
        }
    }

    public void testBuildFromBean() {
        final ConditionBuilder builder = new ConditionBuilderImpl(T1);
        {
            final TestCondition conditionBean = new TestCondition();
            conditionBean.setDateField(null);
            conditionBean.setIntField(null);
            conditionBean.setStringField(null);
            final IExpression condition = builder.execute(conditionBean);
            //
            assertEquals(true, condition instanceof ICompositeExpression);
            final ICompositeExpression composite = (ICompositeExpression) condition;
            assertEquals(0, composite.size());
        }
        {
            final TestCondition conditionBean = new TestCondition();
            conditionBean.setDateField(null);
            conditionBean.setIntField(null);
            conditionBean.setStringField("abc");
            final IExpression condition = builder.execute(conditionBean);
            //
            assertEquals(true, condition instanceof ICompositeExpression);
            final ICompositeExpression composite = (ICompositeExpression) condition;
            assertEquals(1, composite.size());
            assertEquals(true, composite.get(0) instanceof IFieldValuedExpression);
            final IFieldValuedExpression expression1 = (IFieldValuedExpression) composite.get(0);
            assertEquals(T1_F3, expression1.getField().getField());
            assertEquals("abc", expression1.getValue());
            assertEquals(IExpression.EQUAL, expression1.getOperator());
        }

    }

}