/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
package org.asyrinx.brownie.core.collection;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/**
 * RNVɊւ郆[eBeBNXłB
 * @author Akima
 */
public final class CollectionUtils
	extends org.apache.commons.collections.CollectionUtils {

	/**
	 * MapĂValueQListƂĎ擾܂B
	 */
	public static List toList(Map source) {
		final List result = new ArrayList();
		toList(source, result);
		return result;
	}

	/**
	 * MapĂValueQListƂĎ擾܂B
	 */
	public static void toList(Map source, List dest) {
		final Iterator iter = source.keySet().iterator();
		while (iter.hasNext())
			dest.add(source.get(iter.next()));
	}

	/**
	 * source̗vf(Q)ListƂĎ擾܂B
	 */
	public static List toList(Object[] source) {
		final List result = new ArrayList();
		toList(source, result);
		return result;
	}

	/**
	 * source̗vf(Q)ListƂĎ擾܂B
	 */
	public static void toList(Object[] source, List dest) {
		for (int i = 0; i < source.length; i++) {
			dest.add(source[i]);
		}
	}

	/**
	 * hashCodeƍvnbVR[hێIuWFNg
	 * source猟܂B
	 */
	public static Object find(List source, int hashCode) {
		for (int i = 0; i < source.size(); i++) {
			if (source.get(i).hashCode() == hashCode) {
				return source.get(i);
			}
		}
		return null;
	}

	/**
	 * sourceɁAdvf邩ǂ𒲂ׂ܂B
	 */
	public static boolean hasDuplicates(List source) {
		final List checked = new ArrayList();
		for (int i = source.size() - 1; i > -1; i--) {
			if (checked.contains(source.get(i))) {
				return true;
			} else {
				checked.add(source.get(i));
			}
		}
		return false;
	}

	/**
	 * w肳ꂽListw肳ꂽ̗vf擪vf폜܂B
	 * @param target ΏۂƂȂList
	 * @param count 폜
	 */
	public static void removeFromFirst(List target, int count) {
		removeFromIndex(target, 0, Math.abs(count));
	}

	/**
	 * w肳ꂽListw肳ꂽ̗vf𖖔vf폜܂B
	 * @param target ΏۂƂȂList
	 * @param count 폜
	 */
	public static void removeFromLast(List target, int count) {
		if (target == null)
			return;
		removeFromIndex(target, target.size() - 1, Math.abs(count) * -1);
	}

	/**
	 * w肳ꂽListw肳ꂽ̗vfw肳ꂽCfbNX珇ɗvf폜܂B
	 * @param target ΏۂƂȂList
	 * @param index 폜n߂CfbNX
	 * @param count 폜B}CiXlw肵ꍇ͋tɍ폜Ă܂B
	 */
	public static void removeFromIndex(List target, int index, int count) {
		if (target == null)
			return;
		final boolean backward = count < 0;
		count = Math.abs(count);
		while (!target.isEmpty()
			&& count > 0
			&& index > -1
			&& index < target.size()) {
			target.remove(index);
			count--;
			if (backward)
				index--;
		}
	}

}
