/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/01/04
 */
package org.asyrinx.brownie.core.collection;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

import org.asyrinx.brownie.core.lang.ArrayUtils;
import org.asyrinx.brownie.core.lang.StringUtils;
/**
 * A}bvc[\ƂĈ߂̃NXłB<br>
 * PropertiesNXւ̃VACYAfVACY\łB<br>
 * Ⴆ΁Aȉ̂悤ȗvfĂPropertiesIuWFNgƂ܂B<br>
 * <pre>
 * aaa.aaa = 000
 * aaa.bbb.ccc = 111
 * aaa.bbb.ddd = 222
 * aaa.bbb.eee.fff = 333
 * </pre>
 * PropertiesIuWFNgloadFromMapTreeIuWFNǵA
 * IɈȉ̂悤Map̃c[쐬܂B
 * <pre>
 * (root:Map)
 *   - aaa = Map }
 *     - aaa = 000 t
 *     - bbb = Map }
 *       - ccc = 111 t
 *       - ddd = 222 t
 *       - eee = Map }
 *         - fff = 333 t
 * </pre>
 * rootƂȂMapgetRoot\bhŎ擾\łB<br>
 * ܂aaacccȂǂ̗vfgetMap\bhɂĎ擾\łB<br>
 * 
 * @author akima
 */
public class MapTree {

	/**
	 * 
	 */
	public MapTree() {
		this(new HashMap());
	}

	/**
	 * 
	 */
	public MapTree(Map root) {
		super();
		this.root = root;
	}

	/**
	 * 
	 */
	public MapTree(MapTree mapTree) {
		this(mapTree.getRoot());
	}

	protected final Map root;
	private String keyDelimiter = ".";

	protected Object[] toKeys(Object key) {
		final String keyStr = String.valueOf(key);
		return StringUtils.tokenizeToArray(keyStr, keyDelimiter);
	}

	/**
	 * MapTreeɗvfǉ܂B
	 * 
	 * @param key 
	 * Object̔z񂠂邢͕ƂĈ܂B
	 * keyɃIuWFNg̔zw肵ꍇA̔z̊evfc[̎}ƂȂ܂B
	 * ̏ꍇAkeyDelimitervpeBŎw肵ɂĕA
	 * ꂽevfc[̎}ƂȂ܂B
	 * AL[ɂĎw肳ꂽ݂Ȃꍇɂ͎Iɍ쐬܂B
	 * 
	 * @param value 
	 * ǉvfłB
	 */
	public void put(Object key, Object value) {
		if (key instanceof Object[]) {
			put((Object[]) key, value);
		} else {
			put(toKeys(key), value);
		}
	}

	/**
	 * L[ɂĎw肳ꂽ}邢͗tԂ܂B
	 * 
	 * @param key 
	 * Object̔z񂠂邢͕ƂĈ܂B
	 * keyɃIuWFNg̔zw肵ꍇA̔z̊evfc[̎}ƂȂ܂B
	 * ̏ꍇAkeyDelimitervpeBŎw肵ɂĕA
	 * ꂽevfc[̎}ƂȂ܂B
	 * 
	 * @return
	 * L[ɂĎw肳ꂽ݂ȂꍇɂnullԂ܂B
	 */
	public Object get(Object key) {
		if (key instanceof Object[]) {
			return get((Object[]) key);
		} else {
			return get(toKeys(key));
		}
	}

	/**
	 * @param key ̔z̊evfc[̎}ƂȂ܂B
	 * AL[ɂĎw肳ꂽ݂Ȃꍇɂ͎Iɍ쐬܂B
	 * 
	 * @param value 
	 * ǉvfłB
	 */
	public void put(Object[] key, Object value) {
		if (key == null || key.length == 0)
			return;
		final Map map =
			(key.length == 1)
				? root
				: needMap(ArrayUtils.subArray(key, 0, key.length - 1));
		map.put(key[key.length - 1], value);
	}

	/**
	 * L[ɂĎw肳ꂽ}邢͗tԂ܂B
	 * 
	 * @param key 
	 * z̊evfc[̎}ƂĈ܂B
	 * 
	 * @return
	 * L[ɂĎw肳ꂽ݂ȂꍇɂnullԂ܂B
	 */
	public Object get(Object[] keys) {
		if (keys == null || keys.length == 0)
			return null;
		final Map map =
			(keys.length == 1)
				? root
				: getMap(ArrayUtils.subArray(keys, 0, keys.length - 1));
		return (map == null) ? null : map.get(keys[keys.length - 1]);
	}

	/**
	 * MapTreeIuWFNgێ鍪MapIuWFNgԂ܂B
	 * @return
	 */
	public Map getRoot() {
		return root;
	}

	/**
	 * L[ɂĎw肳ꂽ}MapIuWFNgԂ܂B
	 * @param key
	 * Object̔z񂠂邢͕ƂĈ܂B
	 * keyɃIuWFNg̔zw肵ꍇA̔z̊evfc[̎}ƂȂ܂B
	 * ̏ꍇAkeyDelimitervpeBŎw肵ɂĕA
	 * ꂽevfc[̎}ƂȂ܂B
	 * @return
	 */
	public Map getMap(Object key) {
		if (key instanceof Object[]) {
			return getMap((Object[]) key);
		} else {
			return getMap(toKeys(key));
		}
	}

	/**
	 * L[ɂĎw肳ꂽ}MapIuWFNgԂ܂B
	 * @param key
	 * z̊evfc[̎}ƂĈ܂B
	 * @return
	 */
	protected Map getMap(Object[] keys) {
		Map current = root;
		for (int i = 0; i < keys.length; i++) {
			Object val = current.get(keys[i]);
			if (val instanceof Map) {
				current = (Map) val;
			} else {
				return null;
			}
		}
		return current;
	}

	protected Map needMap(Object[] keys) {
		Map current = root;
		for (int i = 0; i < keys.length; i++) {
			Object val = current.get(keys[i]);
			if (val instanceof Map) {
				current = (Map) val;
			} else {
				final Map newMap = createMap();
				current.put(keys[i], newMap);
				current = newMap;
			}
		}
		return current;
	}

	protected Map createMap() {
		return new HashMap();
	}

	/**
	 * ŃL[w肵ꍇɊe}̖̂Ƃĕ邽߂̕łB
	 * @return
	 */
	public String getKeyDelimiter() {
		return keyDelimiter;
	}

	/**
	 * ŃL[w肵ꍇɊe}̖̂Ƃĕ邽߂̕łB
	 * @param string
	 */
	public void setKeyDelimiter(String string) {
		keyDelimiter = string;
	}

	/**
	 * ێf[^PropertiesIuWFNgɃVACY܂B
	 * @param properties
	 */
	public void saveTo(Properties properties) {
		final Properties props = properties;
		final MapTreeVisitor visitor = new MapTreeVisitor(this.root) {
			public void doOnLeaf(Object value) {
				final String key =
					StringUtils.connectString(keyStack, keyDelimiter);
				props.put(key, value);
			}
		};
		visitor.execute();
	}

	/**
	 * PropertiesIuWFNgf[^fVACY܂B
	 * @param properties
	 */
	public void loadFrom(Properties properties) {
		final Iterator iterator = properties.keySet().iterator();
		while (iterator.hasNext()) {
			final Object key = iterator.next();
			this.put(key, properties.get(key));
		}
	}

}
