/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
package org.asyrinx.brownie.core.collection;

import java.util.Collection;

import org.asyrinx.brownie.core.collection.wrapper.ListWrapper;

/**
 * FIFÕL[\NXł
 * @author akima
 */
public class QueueList extends ListWrapper {

	/**
	 * Constructor for QueueList.
	 */
	public QueueList() {
		super();
	}

	/**
	 * Constructor for QueueList.
	 * @param c
	 */
	public QueueList(Collection c) {
		super(c);
		deleteSurplusItems();
	}

	/**
	 * Constructor for QueueList.
	 * @param maxSize 
	 */
	public QueueList(int maxSize) {
		super();
		this.maxSize = maxSize;
	}

	/**
	 * Constructor for QueueList.
	 * @param c
	 */
	public QueueList(Collection c, int maxSize) {
		super(c);
		this.maxSize = maxSize;
		deleteSurplusItems();
	}

	private int maxSize = 100;

	/**
	 */
	public void add(int index, Object element) {
		super.add(index, element);
		deleteSurplusItems();
	}

	/**
	 */
	public boolean add(Object o) {
		final boolean result = super.add(o);
		deleteSurplusItems();
		return result;
	}

	/**
	 */
	public boolean addAll(Collection c) {
		final boolean result = super.addAll(c);
		deleteSurplusItems();
		return result;
	}

	/**
	 */
	public boolean addAll(int index, Collection c) {
		final boolean result = super.addAll(index, c);
		deleteSurplusItems();
		return result;
	}

	/**
	 * ]ȍڂ폜B
	 */
	private void deleteSurplusItems() {
		if (list.size() < maxSize)
			return;
		while (list.size() > maxSize) {
			list.remove(0);
		}
	}

	/**
	 * Returns the maxSize.
	 * @return int
	 */
	public int getMaxSize() {
		return maxSize;
	}

	/**
	 * Sets the maxSize.
	 * @param maxSize The maxSize to set
	 */
	public void setMaxSize(int maxSize) {
		this.maxSize = maxSize;
	}

}
