/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
package org.asyrinx.brownie.core.collection.wrapper;

import java.util.Collection;
import java.util.Iterator;

import org.asyrinx.brownie.core.util.Wrapper;

/**
 * @author Akima
 */
public class CollectionWrapper extends Wrapper implements Collection {

	/**
	 * Constructor for CollectionWrapper.
	 */
	public CollectionWrapper(Collection impl) {
		super(impl);
		this.collection = impl;
	}

	private final Collection collection;

	/**
	 * @see java.util.Collection#size()
	 */
	public int size() {
		return collection.size();
	}

	/**
	 * @see java.util.Collection#isEmpty()
	 */
	public boolean isEmpty() {
		return collection.isEmpty();
	}

	/**
	 * @see java.util.Collection#contains(Object)
	 */
	public boolean contains(Object o) {
		return collection.contains(o);
	}

	/**
	 * @see java.util.Collection#iterator()
	 */
	public Iterator iterator() {
		return collection.iterator();
	}

	/**
	 * @see java.util.Collection#toArray()
	 */
	public Object[] toArray() {
		return collection.toArray();
	}

	/**
	 * @see java.util.Collection#toArray(Object[])
	 */
	public Object[] toArray(Object[] a) {
		return collection.toArray(a);
	}

	/**
	 * @see java.util.Collection#add(Object)
	 */
	public boolean add(Object o) {
		return collection.add(o);
	}

	/**
	 * @see java.util.Collection#remove(Object)
	 */
	public boolean remove(Object o) {
		return collection.remove(o);
	}

	/**
	 * @see java.util.Collection#containsAll(Collection)
	 */
	public boolean containsAll(Collection c) {
		return collection.containsAll(c);
	}

	/**
	 * @see java.util.Collection#addAll(Collection)
	 */
	public boolean addAll(Collection c) {
		return collection.addAll(c);
	}

	/**
	 * @see java.util.Collection#removeAll(Collection)
	 */
	public boolean removeAll(Collection c) {
		return collection.removeAll(c);
	}

	/**
	 * @see java.util.Collection#retainAll(Collection)
	 */
	public boolean retainAll(Collection c) {
		return collection.retainAll(c);
	}

	/**
	 * @see java.util.Collection#clear()
	 */
	public void clear() {
		collection.clear();
	}

	/**
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		return collection.toString();
	}

}
