/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
package org.asyrinx.brownie.core.collection.wrapper;

import java.util.ListIterator;

/**
 * 
 * @author akima
 */
public class ListIteratorWrapper extends IteratorWrapper implements ListIterator {

	/**
	 * Constructor for ListIteratorWrapper.
	 */
	public ListIteratorWrapper(ListIterator impl) {
		super(impl);
		this.impl = impl;
	}
	
	private final ListIterator impl;

	/**
	 * @see java.util.ListIterator#hasPrevious()
	 */
	public boolean hasPrevious() {
		return impl.hasPrevious();
	}

	/**
	 * @see java.util.ListIterator#previous()
	 */
	public Object previous() {
		return impl.previous();
	}

	/**
	 * @see java.util.ListIterator#nextIndex()
	 */
	public int nextIndex() {
		return impl.nextIndex();
	}

	/**
	 * @see java.util.ListIterator#previousIndex()
	 */
	public int previousIndex() {
		return impl.previousIndex();
	}

	/**
	 * @see java.util.ListIterator#set(Object)
	 */
	public void set(Object o) {
		impl.set(o);
	}

	/**
	 * @see java.util.ListIterator#add(Object)
	 */
	public void add(Object o) {
		impl.add(o);
	}

}
