/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
package org.asyrinx.brownie.core.collection.wrapper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;

/**
 * 
 * @author akima
 */
public class ListWrapper extends CollectionWrapper implements List {

	/**
	 * Constructor for ArrayListQueue.
	 * @param initialCapacity
	 */
	public ListWrapper(int initialCapacity) {
		this(new ArrayList(initialCapacity));
	}

	/**
	 * Constructor for ArrayListQueue.
	 */
	public ListWrapper() {
		this(new ArrayList());
	}

	/**
	 * Constructor for ArrayListQueue.
	 * @param c
	 */
	public ListWrapper(Collection c) {
		this(new ArrayList(c));
	}
	
	public ListWrapper(List list){
		super(list);
		this.list = list;	
	}

	protected final List list;

	/**
	 * @see java.util.List#add(int, Object)
	 */
	public void add(int index, Object element) {
		list.add(index, element);
	}

	/**
	 * @see java.util.List#addAll(int, Collection)
	 */
	public boolean addAll(int index, Collection c) {
		return list.addAll(index, c);
	}

	/**
	 * @see java.util.List#get(int)
	 */
	public Object get(int index) {
		return list.get(index);
	}

	/**
	 * @see java.util.List#indexOf(Object)
	 */
	public int indexOf(Object o) {
		return list.indexOf(o);
	}

	/**
	 * @see java.util.List#lastIndexOf(Object)
	 */
	public int lastIndexOf(Object o) {
		return list.lastIndexOf(o);
	}

	/**
	 * @see java.util.List#listIterator()
	 */
	public ListIterator listIterator() {
		return list.listIterator();
	}

	/**
	 * @see java.util.List#listIterator(int)
	 */
	public ListIterator listIterator(int index) {
		return list.listIterator(index);
	}

	/**
	 * @see java.util.List#remove(int)
	 */
	public Object remove(int index) {
		return list.remove(index);
	}

	/**
	 * @see java.util.List#set(int, Object)
	 */
	public Object set(int index, Object element) {
		return list.set(index, element);
	}
	
	/**
	 * @see java.util.List#subList(int, int)
	 */
	public List subList(int fromIndex, int toIndex) {
		return list.subList(fromIndex, toIndex);
	}
	
	/**
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		return list.toString();
	}


}
