/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
package org.asyrinx.brownie.core.io;

import java.io.File;
import java.util.List;

import org.asyrinx.brownie.core.lang.ArrayUtils;
import org.asyrinx.brownie.core.lang.StringUtils;

/**
 * @author Akima
 */
public final class FileNameUtils {

	/**
	 * t@C̊gqZIPkĂ̂ǂ𔻒f܂B
	 * @param filename
	 * @return
	 */
	public static boolean hasZipExtension(String filename) {
		final String ext =
			StringUtils.nullTrim(getExtension(filename)).toLowerCase();
		return (
			ext.equals(FileConstants.EXT_ZIP)
				|| ext.equals(FileConstants.EXT_JAR)
				|| ext.equals(FileConstants.EXT_WAR)
				|| ext.equals(FileConstants.EXT_EAR));
	}

	/**
	 * ̃t@C΃pXǂ肷
	 * 
	 * @param fileName
	 * @return boolean
	 */
	public static boolean isAbsolutePath(String fileName) {
		File f = new File(fileName);
		return f.isAbsolute();
	}

	/**
	 * Ώۂ̃pX΃pXɂĕԂ<BR>
	 * [gpXƌqۂɁAZp[^̏dE`FbNB
	 * 
	 * @param path ΏۃpX
	 * @param rootPath [g̃pX
	 * @return String ΃pX
	 */
	public static String toAbsolutePath(String rootPath, String path) {
		if (isAbsolutePath(path)) {
			return path;
		} else if (StringUtils.isEmpty(rootPath)) {
			return path;
		}
		final PathPointer pointer = new PathPointer(rootPath);
		pointer.moveTo(path);
		return replaceSeparator(
			pointer.getPath(),
			getFileSeparator(rootPath),
			getFileSeparator(path));
	}

	/**
	 * ̍Ōオ؂蕶ǂ𔻒fB
	 */
	public static boolean isSeparatorTail(String path) {
		return isSeparator(path, File.separator, false)
			|| isSeparator(path, FileConstants.FILE_SPARATOR_SLASH, false);
	}

	/**
	 * ̐擪؂蕶ǂ𔻒fB
	 */
	public static boolean isSeparatorHead(String path) {
		return isSeparator(path, File.separator, true)
			|| isSeparator(path, FileConstants.FILE_SPARATOR_SLASH, true);
	}

	private static boolean isSeparator(
		String path,
		String separator,
		boolean isHead) {
		if (path == null)
			return false;
		if (path.length() < File.separator.length())
			return false;
		final String target =
			isHead
				? path.substring(0, File.separator.length())
				: path.substring(path.length() - File.separator.length());
		return separator.equals(target);
	}

	public static boolean hasFileSeparator(String path) {
		return hasFileSeparator(path, File.separator);
	}

	public static boolean hasFileSeparatorSlash(String path) {
		return hasFileSeparator(path, FileConstants.FILE_SPARATOR_SLASH);
	}

	private static boolean hasFileSeparator(String path, String separator) {
		return path.indexOf(separator) > -1;
	}

	/**
	 * 
	 * @param path
	 * @return
	 */
	public static String adjustFileSeparator(String path) {
		return toFileSeparatorSlash(path);
	}

	public static String toFileSeparatorSlash(String path) {
		return hasFileSeparator(path)
			? replaceSeparator(
				path,
				File.separator,
				FileConstants.FILE_SPARATOR_SLASH)
			: path;
	}

	public static String toFileSeparator(String path) {
		return hasFileSeparatorSlash(path)
			? replaceSeparator(
				path,
				FileConstants.FILE_SPARATOR_SLASH,
				File.separator)
			: path;
	}

	public static String toFileSeparator(String path, String separator) {
		return replaceSeparator(
			replaceSeparator(
				path,
				FileConstants.FILE_SPARATOR_SLASH,
				separator),
			File.separator,
			separator);
	}

	/**
	 * 
	 * @param path
	 * @return
	 */
	public static boolean hasOneKindSeparator(String path) {
		final boolean hasFS = hasFileSeparator(path);
		final boolean hasFSS = hasFileSeparatorSlash(path);
		return !(hasFS && hasFSS);
	}
	/**
	 * 
	 * @param path
	 * @return
	 */
	public static String getFileSeparator(String path) {
		final boolean hasFS = hasFileSeparator(path);
		final boolean hasFSS = hasFileSeparatorSlash(path);
		if (hasFS && !hasFSS)
			return File.separator;
		else
			return FileConstants.FILE_SPARATOR_SLASH;
	}

	/**
	 * ̐擪ɋ؂蕶tB
	 * A擪؂蕶łꍇɂ͈߂肿ƂĕԂB
	 */
	public static String addSeparatorHead(String path) {
		if (isSeparatorHead(path)) {
			return path;
		} else {
			return getFileSeparator(path) + path;
		}
	}

	/**
	 * ̖ɋ؂蕶tB
	 * A؂蕶łꍇɂ͈߂肿ƂĕԂB
	 */
	public static String addSeparatorTail(String path) {
		if (isSeparatorTail(path)) {
			return path;
		} else {
			return path + getFileSeparator(path);
		}
	}

	/**
	 * ̐擪̋؂蕶폜B
	 * A擪؂蕶łȂꍇɂ͈߂肿ƂĕԂB
	 */
	public static String deleteSeparatorHead(String path) {
		if (isSeparatorHead(path)) {
			final String separator = FileNameUtils.getFileSeparator(path);
			return path.substring(
				separator.length(),
				path.length() - separator.length() + 1);
		} else {
			return path;
		}
	}

	/**
	 * ̍Ō̋؂蕶폜B
	 * A؂蕶łȂꍇɂ͈߂lƂĕԂB
	 */
	public static String deleteSeparatorTail(String path) {
		if (isSeparatorTail(path)) {
			return path.substring(0, path.length() - File.separator.length());
		} else {
			return path;
		}
	}

	/**
	 * Ώۃt@C̐ẽpXԂ
	 * 
	 * @param path Ώۃt@C
	 * @return String ẽpX
	 */
	public static String getParentPath(String path) {
		if (StringUtils.isEmpty(path))
			return null;
		return new File(path).getParent();
	}

	/**
	 * t@CZp[^u
	 * 
	 * @param path uΏۃpX
	 * @param oldSeparator uÕZp[^
	 * @param newSeparator ũZp[^
	 * @return String@ũpX
	 */
	public static String replaceSeparator(
		String path,
		String oldSeparator,
		String newSeparator) {
		return StringUtils.replace(path, oldSeparator, newSeparator);
	}

	public static String replaceSeparatorSlash(String path) {
		return StringUtils.replace(
			path,
			FileConstants.FILE_SPARATOR_SLASH,
			File.separator);
	}

	/**
	 * pX̐擪w肳ꂽpX폜B
	 * @param targetPath ҏWΏ
	 * @param deletePath 폜pX
	 * 擪̃pXvȂꍇɂ́AҏW̕ԋpB
	 */
	private static String deleteHeadPath(
		String targetPath,
		String deletePath,
		boolean addSeparator) {
		if (addSeparator) {
			deletePath = deleteSeparatorTail(deletePath);
		} else {
			deletePath = addSeparatorTail(deletePath);
		}
		int idx = targetPath.indexOf(deletePath);
		if (idx != 0)
			return targetPath;
		String result = targetPath.substring(deletePath.length());
		if (addSeparator) {
			return addSeparatorHead(result);
		} else {
			return deleteSeparatorHead(result);
		}
	}

	/**
	 * Method toRelativePath.
	 * @param filePath
	 * @param basePath
	 * @return 
	 */
	public static String toRelativePath(String filePath, String basePath) {
		if (StringUtils.isEmpty(filePath))
			return null;
		if (StringUtils.isEmpty(basePath))
			return filePath;
		basePath =
			replaceSeparator(
				deleteSeparatorTail(basePath),
				File.separator,
				FileConstants.FILE_SPARATOR_SLASH);
		filePath =
			replaceSeparator(
				deleteSeparatorTail(filePath),
				File.separator,
				FileConstants.FILE_SPARATOR_SLASH);
		if (filePath.equals(basePath))
			return FileConstants.DIRECTORY_CURRENT;
		if (filePath.startsWith(basePath)) {
			return FileConstants.DIRECTORY_CURRENT
				+ addSeparatorHead(deleteHeadPath(filePath, basePath, true));
		} else if (basePath.startsWith(filePath)) {
			final String diff = StringUtils.difference(filePath, basePath);
			return toParentPath(diff);
		} else {
			final int diffIndex =
				StringUtils.indexOfDifference(filePath, basePath);
			final String baseDiff = basePath.substring(diffIndex);
			final String fileDiff = filePath.substring(diffIndex);
			return toParentPath(FileConstants.FILE_SPARATOR_SLASH + baseDiff)
				+ FileConstants.FILE_SPARATOR_SLASH
				+ fileDiff;
		}
	}

	private static String toParentPath(final String diff) {
		final int slashCount =
			StringUtils.countMatches(diff, FileConstants.FILE_SPARATOR_SLASH);
		return StringUtils.repeat(
			FileConstants.DIRECTORY_PARENT + FileConstants.FILE_SPARATOR_SLASH,
			slashCount - 1)
			+ FileConstants.DIRECTORY_PARENT;
	}

	/**
	 * t@C̊gq擾B
	 */
	public static String getExtension(String fileName) {
		if (fileName == null)
			return null;
		String[] parsed =
			StringUtils.tokenizeToArray(fileName, FileConstants.DELIM_EXT_STR);
		if (parsed.length < 2) {
			return null;
		} else {
			final String result = (String) ArrayUtils.getLast(parsed);
			if (replaceSeparatorSlash(result).indexOf(File.separatorChar) > -1)
				return "";
			else
				return result;
		}
	}

	/**
	 * t@Cgq菜
	 * @param fileName
	 * @return
	 */
	public static String removeExtension(String fileName) {
		if (fileName == null)
			return null;
		final String ext = getExtension(fileName);
		if (ext == null) {
			return fileName;
		} else {
			return fileName.substring(0, fileName.length() - ext.length() - 1);
		}
	}

	/**
	 * t@C̊gq擾B
	 */
	public static String changeExtension(
		String fileName,
		String newExtension) {
		if (fileName == null)
			return null;
		final String baseFileName = removeExtension(fileName);
		if (StringUtils.isEmpty(newExtension)) {
			return baseFileName;
		} else {
			if (newExtension.charAt(0) != FileConstants.DELIM_EXT)
				newExtension = FileConstants.DELIM_EXT + newExtension;
			return baseFileName + newExtension;
		}
	}

	/**
	 * URLǂ𔻒fB
	 * @param string
	 * @return
	 */
	public static boolean isURL(String string) {
		return string.indexOf("://") > -1;
	}

	/**
	 * ؂蕶iWindowsȂ';'AUnixnȂ':'jŃt@CQ؂蕪
	 * @param fileNames
	 * @return
	 */
	public static List parseFileNames(String fileNames) {
		return StringUtils.tokenize(fileNames, File.pathSeparator);
	}

	/**
	 * IuWFNgFileƂĕԂ܂B
	 * @param obj
	 * @return
	 */
	public static File toFile(Object obj) {
		if (obj == null)
			return null;
		if ("".equals(obj))
			return null;
		if (obj instanceof File)
			return (File) obj;
		return new File(String.valueOf(obj));
	}
}
