/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2003/11/04
 */
package org.asyrinx.brownie.core.io;

import java.io.File;

/**
 * t@C̕ύXĎXbhłB
 * @author akima
 */
public abstract class FileWatchdog extends Thread {

	/**
	   The default delay between every file modification check, set to 60
	   seconds.  */
	static final public long DEFAULT_DELAY = 60000;

	/**
	   The delay to observe between every check. By default set {@link
	   #DEFAULT_DELAY}. */
	protected long delay = DEFAULT_DELAY;

	private final File file;

	private long lastModified = 0;
	private boolean warnedAlready = false;
	private boolean interrupted = false;

	protected FileWatchdog(String filename) {
		this(filename, DEFAULT_DELAY);
	}

	protected FileWatchdog(String filename, long delay_msec) {
		this.file = new File(filename);
		this.delay = delay_msec;
		setDaemon(true);
		//checkAndConfigure();
	}

	/**
	   Set the delay to observe between each check of the file changes.
	 */
	public void setDelay(long delay) {
		this.delay = delay;
	}

	abstract protected void doOnChange();

	public void checkAndConfigure() {
		final boolean fileExists;
		try {
			fileExists = file.exists();
		} catch (SecurityException e) {
			System.err.println(
				"Was not allowed to read check file existance, file:["
					+ file.getAbsolutePath()
					+ "].");
			interrupted = true; // there is no point in continuing
			return;
		}

		if (fileExists) {
			long l = file.lastModified();
			// this can also throw a SecurityException
			if (l > lastModified) { // however, if we reached this point this
				lastModified = l; // is very unlikely.
				doOnChange();
				warnedAlready = false;
			}
		} else {
			if (!warnedAlready) {
				System.err.println(
					"[" + file.getAbsolutePath() + "] does not exist.");
				warnedAlready = true;
			}
		}
	}

	public void run() {
		while (!interrupted) {
			try {
				Thread.sleep(delay);
			} catch (InterruptedException e) {
				// no interruption expected
			}
			checkAndConfigure();
		}
	}
}
