/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
package org.asyrinx.brownie.core.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;

/**
 * InputStreamAOutputStreamAReaderAWriterɊւ郆[eBeBNXłB
 * @author Akima
 */
public final class StreamUtils {

	/**
	 * Constructor for StreamUtils.
	 */
	private StreamUtils() {
		super();
	}

	/**
	 * QReaderŎ擾eǂ𔻒f܂B
	 * @param target1
	 * @param target2
	 * @return
	 * @throws IOException
	 */
	public static boolean compare(Reader target1, Reader target2)
		throws IOException {
		int c1 = target1.read();
		int c2 = target2.read();
		if (c1 != c2)
			return false;
		while ((c1 > -1) && (c2 > -1)) {
			c1 = target1.read();
			c2 = target2.read();
			if (c1 != c2)
				return false;
		}
		return true;
	}

	/**
	 * QInputStreamŎ擾eǂ𔻒f܂B
	 * @param target1
	 * @param target2
	 * @return
	 * @throws IOException
	 */
	public static boolean compare(InputStream target1, InputStream target2)
		throws IOException {
		return compare(
			new InputStreamReader(target1),
			new InputStreamReader(target2));
	}

	/**
	 * source擾edestɃRs[܂B
	 * @param source
	 * @param dest
	 * @throws IOException
	 */
	public static void copy(InputStream source, OutputStream dest)
		throws IOException {
		copy(source, dest, true);
	}

	/**
	 * 
	 * source擾edestɃRs[܂B
	 * @param source
	 * @param dest
	 * @param buffering truew肳ꂽꍇAsourcedestꂼɂăobt@O܂B
	 * @throws IOException
	 */
	public static void copy(
		InputStream source,
		OutputStream dest,
		boolean buffering)
		throws IOException {
		if (buffering) {
			source = new BufferedInputStream(source);
			dest = new BufferedOutputStream(dest);
		}
		byte buf[] = new byte[256];
		int len;
		while ((len = source.read(buf)) != -1) {
			dest.write(buf, 0, len);
		}
		dest.flush();
	}

	/**
	 * source擾edestɃRs[܂B
	 * @param source
	 * @param dest
	 * @throws IOException
	 */
	public static void copy(Reader source, Writer dest) throws IOException {
		copy(source, dest, true);
	}

	/**
	 * 
	 * source擾edestɃRs[܂B
	 * @param source
	 * @param dest
	 * @param buffering truew肳ꂽꍇAsourcedestꂼɂăobt@O܂B
	 * @throws IOException
	 */
	public static void copy(Reader source, Writer dest, boolean buffering)
		throws IOException {
		if (buffering) {
			source = new BufferedReader(source);
			dest = new BufferedWriter(dest);
		}
		int c = source.read();
		while (c > -1) {
			dest.write(c);
			c = source.read();
		}
		dest.flush();
	}

	/**
	 * sourceInputStream̓eStringBufferdestɃRs[܂B
	 * @param source
	 * @param dest
	 * @throws IOException
	 */
	public static void copy(InputStream source, StringBuffer dest)
		throws IOException {
		copy(source, dest, true);
	}

	/**
	 * sourceInputStream̓eStringBufferdestɃRs[܂B
	 * @param source
	 * @param dest
	 * @param buffering truew肳ꂽꍇAsourcedestꂼɂăobt@O܂B
	 * @throws IOException
	 */
	public static void copy(
		InputStream source,
		StringBuffer dest,
		boolean buffering)
		throws IOException {
		copy(new InputStreamReader(source), dest, buffering);
	}

	/**
	 * sourceReader̓eStringBufferdestɃRs[܂B
	 * @param source
	 * @param dest
	 * @throws IOException
	 */
	public static void copy(Reader source, StringBuffer dest)
		throws IOException {
		copy(source, dest, true);
	}

	/**
	 * sourceReader̓eStringBufferdestɃRs[܂B
	 * @param source
	 * @param dest
	 * @param buffering truew肳ꂽꍇAsourcedestꂼɂăobt@O܂B
	 * @throws IOException
	 */
	public static void copy(
		Reader source,
		StringBuffer dest,
		boolean buffering)
		throws IOException {
		if (buffering) {
			source = new BufferedReader(source);
		}
		int c = source.read();
		while (c > -1) {
			dest.append((char) c);
			c = source.read();
		}
	}
}
