/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
package org.asyrinx.brownie.core.io.sf;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

/**
 * @author Akima
 */
public class ClassResourceStreamFactory extends AbstractFileStreamFactory {

	/**
	 * Constructor for ClassResourceStreamFactory.
	 */
	public ClassResourceStreamFactory() {
		this(null);
	}

	/**
	 * Constructor for ClassResourceStreamFactory.
	 */
	public ClassResourceStreamFactory(ClassLoader classLoader) {
		super();
		if (classLoader == null)
			classLoader = this.getClass().getClassLoader();
		this.classLoader = classLoader;
	}

	/**
	 * @see org.asyrinx.brownie.core.io.sf.FileStreamFactory#toFile(java.lang.String)
	 */
	public String toFilePath(String fileName) {
		return fileName;
	}

	private final ClassLoader classLoader;

	/**
	 */
	public InputStream newInput(String fileName) throws IOException {
		return newInputImpl(fileName);
	}

	/**
	 */
	protected final InputStream newInputImpl(String fileName) {
		return this.classLoader.getResourceAsStream(fileName);
	}

	/**
	 */
	public OutputStream newOutput(String fileName) throws IOException {
		throw new UnsupportedOperationException();
	}

}
