/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2003/12/15
 */
package org.asyrinx.brownie.core.io.sf;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;

import org.asyrinx.brownie.core.io.FileConstants;
import org.asyrinx.brownie.core.io.PathPointer;
import org.asyrinx.brownie.core.lang.ClassUtils;
import org.asyrinx.brownie.core.lang.InvocationInfo;
import org.asyrinx.brownie.core.lang.StringUtils;

/**
 * @author akima
 */
public class RelativeClassResourceStreamFactory
	extends ClassResourceStreamFactory {

	/**
	 * 
	 */
	public RelativeClassResourceStreamFactory() {
		this(null, null);

	}

	/**
	 * @param classLoader
	 */
	public RelativeClassResourceStreamFactory(ClassLoader classLoader) {
		this(classLoader, null);
	}

	/**
	 * @param classLoader
	 */
	public RelativeClassResourceStreamFactory(String classToBeCalled) {
		this(null, classToBeCalled);
	}

	/**
	 * @param classLoader
	 */
	public RelativeClassResourceStreamFactory(
		ClassLoader classLoader,
		String classToBeCalled) {
		super(
			classLoader != null
				? classLoader
				: Thread.currentThread().getContextClassLoader());
		this.classToBeCalled =
			StringUtils.isEmpty(classToBeCalled)
				? RelativeClassResourceStreamFactory.class.getName()
				: classToBeCalled;
	}

	private final String classToBeCalled;

	/**
	 * This method must be overrided because of InvocationInfo 
	 * @see org.asyrinx.io.sf.AbstractFileStreamFactory#newInput(java.lang.Object)
	 */
	public InputStream newInput(Object key) throws IOException {
		if (key instanceof File) {
			return newInput((File) key);
		} else if (key instanceof String) {
			return newInput((String) key);
		} else {
			throw keyClassMismatch(key);
		}
	}

	/**
	 * This method must be overrided because of InvocationInfo 
	 * @see org.asyrinx.io.sf.AbstractFileStreamFactory#newInput(java.io.File)
	 */
	public InputStream newInput(File file) throws IOException {
		return newInput(file.getPath());
	}

	/**
	 * @see org.asyrinx.io.sf.ClassResourceStreamFactory#newInput(java.lang.String)
	 */
	public InputStream newInput(String fileName) throws IOException {
		return super.newInput(toFilePath(fileName));
	}

	public String toFilePath(String fileName) {
		final InvocationInfo invocationInfo =
			new InvocationInfo(classToBeCalled);
		final String resPath =
			StringUtils.replace(
				invocationInfo.getClassName(),
				ClassUtils.PACKAGE_DELIM,
				FileConstants.FILE_SPARATOR_SLASH);
		final PathPointer pointer = new PathPointer(resPath);
		pointer.goUp();
		pointer.moveTo(fileName);
		String realPath = pointer.getPath();
		return realPath;
	}

	/**
	 * @return
	 */
	public String getClassToBeCalled() {
		return classToBeCalled;
	}

}
