/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
package org.asyrinx.brownie.core.io.sf;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

import org.asyrinx.brownie.core.io.FileNameUtils;

/**
 * @author Akima
 */
public class ZipEntryFileStreamFactory extends DirectoryBaseFileStreamFactory {

	/**
	 * Constructor for ZipEntryFileStreamFactory.
	 */
	public ZipEntryFileStreamFactory(String zipFilePath) {
		this(zipFilePath, "");
	}

	/**
	 * Constructor for ZipEntryFileStreamFactory.
	 */
	public ZipEntryFileStreamFactory(File zipFile) {
		this(zipFile, "");
	}

	/**
	 * Constructor for ZipEntryFileStreamFactory.
	 */
	public ZipEntryFileStreamFactory(
		String zipFilePath,
		String baseDirectory) {
		this(new File(zipFilePath), baseDirectory);
	}

	/**
	 * Constructor for ZipEntryFileStreamFactory.
	 */
	public ZipEntryFileStreamFactory(File zipFile, String baseDirectory) {
		super(baseDirectory);
		this.zipFile = zipFile;
	}

	private final File zipFile;
	private ZipFile targetZip = null;

	protected void initZipFile() throws IOException {
		if (targetZip != null) {
			return;
		}
		targetZip = new ZipFile(this.zipFile);
	}

	public String toZipEntryName(String fileName) {
		return fileName;
	}

	public String toFilePath(String virtualFileName) {
		return FileNameUtils.addSeparatorHead(
			super.toFilePath(virtualFileName));
	}

	/**
	 */
	public InputStream newInput(String fileName) throws IOException {
		initZipFile();
		String path = toFilePath(fileName);
		ZipEntry entry = new ZipEntry(path);
		InputStream result = targetZip.getInputStream(entry);
		if (result == null)
			throw new IOException("Xg[[" + fileName + "]̎擾Ɏs܂B");
		return result;
	}

	/**
	 */
	public OutputStream newOutput(String fileName) throws IOException {
		return null;
	}

}
