/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
package org.asyrinx.brownie.core.lang;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;

/**
 * 
 * NXɊւ郆[eBeBłB
 * <br>
 * NXw肵ANX̃`FbNt̐Ȃǂ
 * ȐӖłB
 * <br>
 * CX^X̃\bhnewObject̂قƂǂ́AbaseClassƂ
 * ClassϐÄɂĐCX^X̃NX
 * Ӑ}ĂNX(邢̓C^tF[X)p()̂Ȃ̂`FbN܂B
 * <br>
 * ̃\bh͗OInstantiationExceptionthrowsĂ܂B
 * ͈ȉ̏ꍇthrow܂B
 * <br>
 * EbaseClassɂ`FbNpXȂB<br>
 * ENXw肳ĂȂB<br>
 * ENXȂB<br>
 * ERXgN^ȂB<br>
 * ERXgN^̈قȂB<br>
 * ENXւ̃ANZXɖ肪B<br>
 * ȆCX^X̗OꍇB<br>
 * <br>
 * @author Akima
 */
public class ClassUtils {

	public static char PACKAGE_DELIM_CHAR = '.';
	public static String PACKAGE_DELIM = ".";

	/**
	 * NXɂĎw肳ꂽNX̃CX^X𐶐܂B
	 * <br>
	 * @param className NX̖O 
	 * @param classLoader NX𖼑OŌۂ̃NX[_
	 * nullw肵ꍇɂ́AJgXbh̃ReLXgNX[_gp܂B
	 * @param baseClass NX̊NX
	 * nullw肵ꍇɂ́AObjectNXclassϐgp܂B
	 * @return ꂽCX^X
	 * @throws InstantiationException
	 */
	public static Object newObject(
		String className,
		ClassLoader classLoader,
		Class baseClass)
		throws InstantiationException {
		if (classLoader == null)
			classLoader = Thread.currentThread().getContextClassLoader();
		if (className == null)
			throw new InstantiationException("className is null !");
		try {
			Class resultClass = classLoader.loadClass(className);
			return newObject(resultClass, baseClass);
		} catch (ClassNotFoundException e) {
			throw new InstantiationException(e.toString());
		}
	}

	/**
	 * NXɂĎw肳ꂽNX̃CX^X𐶐܂B
	 * <br>
	 * @param className NX̖O 
	 * @param baseClass NX̊NX
	 * nullw肵ꍇɂ́AObjectNXclassϐgp܂B
	 * @return ꂽCX^X
	 * @throws InstantiationException
	 */
	public static Object newObject(String className, Class baseClass)
		throws InstantiationException {
		if (className == null)
			throw new InstantiationException("className is null !");
		try {
			Class resultClass = Class.forName(className);
			return newObject(resultClass, baseClass);
		} catch (ClassNotFoundException e) {
			throw new InstantiationException(e.toString());
		}
	}

	/**
	 * w肳ꂽNX̃CX^X𐶐܂B
	 * <br>
	 * @param instanciateClass NX
	 * @param baseClass NX̊NX
	 * nullw肵ꍇɂ́AObjectNXclassϐgp܂B
	 * @return ꂽCX^X
	 * @throws InstantiationException
	 */
	public static Object newObject(Class instanciateClass, Class baseClass)
		throws InstantiationException {
		checkByBaseClass(instanciateClass, baseClass);
		try {
			return instanciateClass.newInstance();
		} catch (IllegalAccessException e) {
			throw new InstantiationException(e.toString());
		}
	}

	/**
	 * RXgN^CX^X𐶐܂B
	 * <br>
	 * @param instanciateClass CX^X̃NXB
	 * @param baseClass CX^X̃NX̊NX
	 * nullw肵ꍇɂ́AObjectNXclassϐgp܂B
	 * @param params RXgN^ɓnB
	 * @return ꂽCX^X
	 * @throws InstantiationException
	 */
	public static Object newObject(
		Class instanciateClass,
		Class baseClass,
		Object[] params)
		throws InstantiationException {
		checkByBaseClass(instanciateClass, baseClass);
		Constructor constructor = findConstructor(instanciateClass, params);
		if (constructor == null)
			throw new InstantiationException("YRXgN^܂ł");
		try {
			return constructor.newInstance(params);
		} catch (InstantiationException e) {
			throw new InstantiationException(e.toString());
		} catch (IllegalAccessException e) {
			throw new InstantiationException(e.toString());
		} catch (InvocationTargetException e) {
			throw new InstantiationException(e.toString());
		}
	}

	/**
	 * RXgN^CX^X𐶐܂B
	 * <br>
	 * @param className NX̖O 
	 * @param classLoader NX𖼑OŌۂ̃NX[_
	 * nullw肵ꍇɂ́AJgXbh̃ReLXgNX[_gp܂B
	 * @param baseClass CX^X̃NX̊NX
	 * nullw肵ꍇɂ́AObjectNXclassϐgp܂B
	 * @param params RXgN^ɓnB
	 * @return ꂽCX^X
	 * @throws InstantiationException
	 */
	public static Object newObject(
		String className,
		ClassLoader classLoader,
		Class baseClass,
		Object[] params)
		throws InstantiationException {
		if (classLoader == null)
			classLoader = Thread.currentThread().getContextClassLoader();
		if (className == null)
			throw new InstantiationException("className is null !");
		try {
			Class resultClass = classLoader.loadClass(className);
			return newObject(resultClass, baseClass, params);
		} catch (ClassNotFoundException e) {
			throw new InstantiationException(e.toString());
		}
	}

	/**
	 * NXƈRXgN^܂B
	 * <br>
	 */
	public static Constructor findConstructor(
		Class targetClass,
		Object[] params) {
		Constructor[] constructors = targetClass.getConstructors();
		for (int i = 0; i < constructors.length; i++) {
			if (matchTypes(params, constructors[i].getParameterTypes()))
				return constructors[i];
		}
		return null;
	}

	/**
	 * values̊evfAvalueTypes̊evf(ClassNX̃CX^X)
	 * CX^XƂđΉ邩ǂ𔻒f܂B
	 * <br>
	 * @return SĂvaluẽNXvalueTypesƍvtrueAłvȂ̂falseB
	 */
	public static boolean matchTypes(Object[] values, Class[] valueTypes) {
		if (values == null)
			return (valueTypes == null) || (valueTypes.length == 0);
		if (valueTypes == null)
			return false;
		if (values.length != valueTypes.length)
			return false;
		for (int i = 0; i < values.length; i++) {
			if (!valueTypes[i].isInstance(values[i]))
				return false;
		}
		return true;
	}

	public static List modifierToString(int value) {
		List result = new ArrayList();
		if (Modifier.isAbstract(value))
			result.add("abstract");
		if (Modifier.isFinal(value))
			result.add("final");
		if (Modifier.isInterface(value))
			result.add("interface");
		if (Modifier.isNative(value))
			result.add("native");
		if (Modifier.isPrivate(value))
			result.add("private");
		if (Modifier.isProtected(value))
			result.add("protected");
		if (Modifier.isPublic(value))
			result.add("public");
		if (Modifier.isStatic(value))
			result.add("static");
		if (Modifier.isStrict(value))
			result.add("strict");
		if (Modifier.isSynchronized(value))
			result.add("synchronized");
		if (Modifier.isTransient(value))
			result.add("transient");
		if (Modifier.isVolatile(value))
			result.add("volatile");
		return result;
	}

	static private void checkByBaseClass(Class targetClass, Class baseClass)
		throws InstantiationException {
		if (baseClass == null)
			baseClass = Object.class;
		if (!baseClass.isAssignableFrom(targetClass))
			throw new InstantiationException(
				targetClass.getName()
					+ "NX"
					+ baseClass.getName()
					+ "NXƌ݊܂");
	}

	/**
	 * w肵targetNXAclassNameŕ\NX̃NXǂԂB
	 * ANXłȂꍇtargetNX̃X[p[NX̃NXƔrB
	 * @param target ΏۂƂȂClassNX̃CX^X
	 * @param className ƍNXB 
	 * @return pc[̂ڂʁANXclassNameƏƍNXtrueȂfalse
	 */
	static public boolean isAssignableFrom(
		Class target,
		final String className) {
		if (className == null)
			return false;
		if (target == null)
			return false;
		if (className.equals(target.getName()))
			return true;
		Class[] intf = target.getInterfaces();
		for (int idx = 0; idx < intf.length; idx++) {
			if (isAssignableFrom(intf[idx], className))
				return true;
		}
		return isAssignableFrom(target.getSuperclass(), className);
	}

	static public void showClassLoaders() {
		showClassLoaders(Thread.currentThread().getContextClassLoader());
	}

	static public void showClassLoaders(Class clazz) {
		showClassLoaders(clazz.getClassLoader());
	}

	static public void showClassLoaders(ClassLoader loader) {
		if (loader == null) {
			return;
		}
		int depth = getClassLoaderDepth(loader);
		ClassLoader target = loader;
		while (target != null) {
			System.out.println(depth + ": " + target);
			depth--;
			target = target.getParent();
		}
	}

	public static int getClassLoaderDepth(ClassLoader loader) {
		int result = 0;
		while (loader != null) {
			result++;
			loader = loader.getParent();
		}
		return result;
	}

	public static boolean isAncestor(
		ClassLoader ancestor,
		ClassLoader target) {
		if (target == null && ancestor == null)
			return true;
		if (target == null)
			return false;
		if (target == ancestor)
			return true;
		return isAncestor(ancestor, target.getParent());
	}

	public static String toShortClassName(Class class1) {
		if (class1 == null)
			return null;
		return toShortClassName(class1.getName());
	}

	public static String toShortClassName(String className) {
		if (StringUtils.isEmpty(className))
			return null;
		final List elements = StringUtils.tokenize(className, PACKAGE_DELIM);
		if (elements == null)
			return null;
		if (elements.isEmpty())
			return null;
		return String.valueOf(elements.get(elements.size() - 1));
	}
}
