/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/01/30
 */
package org.asyrinx.brownie.core.lang;

/**
 * @author akima
 */
public class NumberUtils {

	/**
	 * ̒̐ȊO폜int^ɕϊĕԂ܂B<P>
	 * ϊɎsƂdefaultValueԂ܂B
	 * 
	 * @param value 
	 * @param defaultValue ϊɎsƂɕԂ
	 * @return ϊ̐
	 */
	static public int toInt(Object value, int defaultValue) {
		return toInt(value, defaultValue, true);
	}

	/**
	 * String^int^ɕϊ܂B
	 * ϊOɐƂ݂ȂȂ邩ǂI\łB
	 * 
	 * @param value 
	 * @param defaultValue ϊɎsƂɕԂ
	 * @param deleteNotNumeric Ƃ݂ȂȂ邩ǂ
	 * @return ϊ̐ 
	 */
	static public int toInt(
		Object value,
		int defaultValue,
		boolean deleteNotNumeric) {
		if (value instanceof Number)
			return ((Number) value).intValue();
		final String val =
			(deleteNotNumeric)
				? StringUtils.deleteNotNumeric(value)
				: String.valueOf(value);
		try {
			return Integer.parseInt(val);
		} catch (NumberFormatException e) {
			return defaultValue;
		}
	}

	/**
	 * ̒̐ȊO폜double^ɕϊĕԂ܂B<P>
	 * ϊɎsƂdefaultValueԂ܂B
	 * 
	 * @param value 
	 * @param defaultValue ϊɎsƂɕԂdouble
	 * @return ϊdouble
	 */
	public static double toDouble(Object value, double defaultValue) {
		return toDouble(value, defaultValue, true);
	}

	/**
	 * String^double^ɕϊ܂B
	 * ϊOɐƂ݂ȂȂ邩ǂI\łB
	 * 
	 * @param value 
	 * @param defaultValue ϊɎsƂɕԂdouble
	 * @param deleteNotNumeric Ƃ݂ȂȂ邩ǂ
	 * @return ϊdouble
	 */
	public static double toDouble(
		Object value,
		double defaultValue,
		boolean deleteNotNumeric) {
		if (value instanceof Number)
			return ((Number) value).doubleValue();
		final String val =
			(deleteNotNumeric)
				? StringUtils.deleteNotNumeric(value)
				: String.valueOf(value);
		try {
			return Double.parseDouble(val);
		} catch (NumberFormatException e) {
			return defaultValue;
		}
	}

	/**
	 * ̒̐ȊO폜long^ɕϊĕԂ܂B<P>
	 * ϊɎsƂdefaultValueԂ܂B
	 * 
	 * @param value 
	 * @param defaultValue ϊɎsƂɕԂlong
	 * @return ϊlong
	 */
	public static long toLong(Object value, long defaultValue) {
		return toLong(value, defaultValue, true);
	}

	/**
	 * String^long^ɕϊ܂B
	 * ϊOɐƂ݂ȂȂ邩ǂI\łB
	 * 
	 * @param value 
	 * @param defaultValue ϊɎsƂɕԂlong
	 * @param deleteNotNumeric Ƃ݂ȂȂ邩ǂ
	 * @return ϊlong
	 */
	public static long toLong(
		Object value,
		long defaultValue,
		boolean deleteNotNumeric) {
		if (value instanceof Number)
			return ((Number) value).longValue();
		final String val =
			(deleteNotNumeric)
				? StringUtils.deleteNotNumeric(value)
				: String.valueOf(value);
		try {
			return Long.parseLong(val);
		} catch (NumberFormatException e) {
			return defaultValue;
		}
	}

}
