/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/03/01
 */
package org.asyrinx.brownie.core.lang.enum;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.enum.Enum;
import org.asyrinx.brownie.core.lang.UnsupportedClassRuntimeException;

/**
 * @author akima
 */
public class ValuedEnumSet extends EnumSet {

	/**
	 * 
	 */
	public ValuedEnumSet(Class valuedEnumClass) {
		super(valuedEnumClass);
	}

	/**
	 * @see org.asyrinx.brownie.core.collection.EnumSet#toEntry(org.apache.commons.lang.enum.Enum)
	 */
	protected EnumSetEntry toEntry(Enum enum) {
		if (enum instanceof ValuedEnum)
			return new ValuedEnumSetEntry((ValuedEnum) enum);
		else
			throw new UnsupportedClassRuntimeException(
				enum.getClass().getName());
	}

	public Set getSelectedEnumValues() {
		return toValueSet(new SelectedPredicate(true));
	}

	public Set getUnselectedEnumValues() {
		return toValueSet(new SelectedPredicate(false));
	}

	protected final Set toValueSet(Predicate predicate) {
		final Set result = new HashSet();
		final Iterator iterator = this.iterator();
		while (iterator.hasNext()) {
			final ValuedEnumSetEntry entry =
				(ValuedEnumSetEntry) iterator.next();
			if (predicate.evaluate(entry))
				result.add(entry.getValue());
		}
		return result;
	}

	public EnumSetEntry getEntryByValue(final Object value) {
		return findEntry(new Predicate() {
			public boolean evaluate(Object input) {
				final ValuedEnumSetEntry entry = (ValuedEnumSetEntry) input;
				return value.equals(entry.getValue());
			}
		});
	}

}
