/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/02/21
 */
package org.asyrinx.brownie.core.sql;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

import org.asyrinx.brownie.core.lang.StringUtils;
import org.asyrinx.brownie.core.util.DateRange;
import org.asyrinx.brownie.core.util.DateUtils;

/**
 * @author akima
 */
public class Conditions extends Elements {

	/**
	 * 
	 */
	public Conditions(IBuilder builder) {
		super(builder);
	}

	private Operator connection = Operator.AND;

	/**
	 * @return
	 */
	public Operator getConnection() {
		return connection;
	}

	/**
	 * @param operator
	 */
	public void setConnection(Operator operator) {
		connection = operator;
	}

	/**
	 * Qǉ܂B
	 */
	public Conditions addNewCondition() {
		return addNewCondition(this.getConnection());
	}

	/**
	 * Qǉ܂B
	 */
	public Conditions addNewCondition(Operator connection) {
		final Conditions result = new Conditions(this.builder);
		result.setConnection(connection);
		super.addImpl(result);
		return result;
	}

	/**
	 * ǉ܂B
	 * @param condition
	 */
	public Conditions add(String condition) {
		super.addImpl(condition);
		return this;
	}

	/**
	 * 񂪓ǂƂǉ܂B
	 * <br>
	 * w肳ꂽrĺAVONH[gň͂܂܂B
	 * @param field rtB[h
	 * @param value rl
	 */
	public Conditions addAsString(String field, String value) {
		return add(field, value, Operator.EQUAL);
	}

	/**
	 * ȑǉ܂B
	 * <br>
	 * w肳ꂽrĺAVONH[gň͂܂܂B
	 * @param field rtB[h
	 * @param value rl
	 * @param operater rZq
	 */
	public Conditions add(String field, String value, Operator operater) {
		return add(field, value, operater, true);
	}

	/**
	 * ȑǉ܂B
	 * <br>
	 * @param field rtB[h
	 * @param value rl
	 * @param operater rZq
	 * @param quote rlVONH[gɈ͂ނǂ
	 */
	public Conditions add(
		String field,
		String value,
		Operator operater,
		boolean quote) {
		super.addImpl(builder.buildCondition(field, value, operater, quote));
		return this;
	}

	/**
	 * tB[h̐iintjƂēǂƂǉ܂B
	 * @param field rtB[h
	 * @param value rl
	 */
	public Conditions add(String field, int value) {
		return add(field, value, Operator.EQUAL);
	}

	/**
	 * tB[h̐iintjƂĔrǉ܂B
	 * @param field rtB[h
	 * @param value rl
	 * @param operater rZq
	 */
	public Conditions add(String field, int value, Operator operater) {
		return add(field, String.valueOf(value), operater, false);
	}

	/**
	 * tB[h̐ilongjƂēǂƂǉ܂B
	 * @param field rtB[h
	 * @param value rl
	 */
	public Conditions add(String field, long value) {
		return add(field, value, Operator.EQUAL);
	}

	/**
	 * tB[h̐ilongjƂĔrǉ܂B
	 * @param field rtB[h
	 * @param value rl
	 * @param operater rZq
	 */
	public Conditions add(String field, long value, Operator operater) {
		return add(field, String.valueOf(value), operater, false);
	}

	private DateFormat defaultDateFormat = new SimpleDateFormat();

	public Conditions add(String field, Date value) {
		return add(field, value, Operator.EQUAL);
	}

	public Conditions add(String field, Date value, Operator operater) {
		return add(field, value, operater, defaultDateFormat);
	}

	public Conditions add(String field, Date value, DateFormat dateFormat) {
		return add(field, value, Operator.EQUAL, dateFormat);
	}
	
	public Conditions add(
		String field,
		Date value,
		Operator operater,
		DateFormat dateFormat) {
		return add(field, dateFormat.format(value), operater);
	}

	/**
	 * t̊ԂƂĒǉB
	 * <br>
	 * Ԃ̊Jn/Îǂ炩null邢̓kȂ΁A
	 * w肵ĂȂ̂ƂĈ܂B
	 * @param field ̑ΏۂƂȂtB[h
	 * @param period Ԃ\IuWFNg
	 */
	public Conditions addPeriod(String field, DateRange period) {
		return addPeriod(field, period.getFrom(), period.getTo());
	}

	/**
	 * t̊ԂƂĒǉB
	 * <br>
	 * Ԃ̊Jn/Îǂ炩null邢̓kȂ΁A
	 * w肵ĂȂ̂ƂĈ܂B
	 * @param field ̑ΏۂƂȂtB[h
	 * @param period Ԃ\IuWFNg
	 */
	public Conditions addPeriod(String field, Date from, Date to) {
		return addPeriod(field, from, to, true);
	}

	/**
	 * t̊ԂƂĒǉB
	 * <br>
	 * Ԃ̊Jn/Îǂ炩null邢̓kȂ΁A
	 * w肵ĂȂ̂ƂĈ܂B
	 * @param field ̑ΏۂƂȂtB[h
	 * @param from
	 * @param to
	 * @param adust
	 */
	public Conditions addPeriod(
		String field,
		Date from,
		Date to,
		boolean adust) {
		return addPeriod(field, from, to, adust, defaultDateFormat);
	}

	/**
	 * t̊ԂƂĒǉB
	 * <br>
	 * Ԃ̊Jn/Îǂ炩null邢̓kȂ΁A
	 * w肵ĂȂ̂ƂĈ܂B
	 * @param field ̑ΏۂƂȂtB[h
	 * @param from
	 * @param to
	 * @param adust
	 */
	public Conditions addPeriod(
		String field,
		Date from,
		Date to,
		boolean adust,
		DateFormat dateFormat) {
		if (adust) {
			if (from != null)
				from = DateUtils.adjustDateBegin(from);
			if (to != null)
				to = DateUtils.adjustDateEnd(to);
		}
		return addPeriod(
			field,
			(from == null) ? null : dateFormat.format(from),
			(to == null) ? null : dateFormat.format(to));
	}

	/**
	 * t̊ԂƂĒǉB
	 * <br>
	 * Ԃ̊Jn/Îǂ炩null邢̓kȂ΁A
	 * w肵ĂȂ̂ƂĈ܂B
	 * <br>
	 * adjusttOtruew肵ꍇAԂ̊Jn̎̕000bɁA
	 * Ԃ̏I̎͂̕235959bɒ܂B
	 * @param field ̑ΏۂƂȂtB[h
	 * @param from Ԃ̊Jn\
	 * @param to Ԃ̏I\
	 */
	public Conditions addPeriod(String field, String from, String to) {
		if (!StringUtils.isAvailable(field))
			return this;
		if (StringUtils.isAvailable(from))
			this.add(field, from, Operator.GREATER_EQUAL);
		if (StringUtils.isAvailable(to))
			this.add(field, to, Operator.LESS_EQUAL);
		return this;
	}

}
