/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/03/01
 */
package org.asyrinx.brownie.core.sql2;

import java.util.Collection;
import java.util.Iterator;

import org.apache.commons.collections.IteratorUtils;
import org.asyrinx.brownie.core.lang.ArrayUtils;
import org.asyrinx.brownie.core.lang.StringUtils;
import org.asyrinx.brownie.core.sql.Operator;

/**
 * @author akima
 */
public class BasicSqlBuilder implements Visitor, SqlBuilder {

	/**
	 * 
	 */
	public BasicSqlBuilder() {
		super();
	}

	private StringBuffer result = null;
	private StringBuffer work = null;

	/**
	 * @see org.asyrinx.brownie.core.sql2.SqlBuilder#toSql(org.asyrinx.brownie.core.sql2.Select)
	 */
	public String toSql(Select select) {
		select.accept(this);
		return result.toString();
	}

	/**
	 * @see org.asyrinx.brownie.core.sql2.Visitor#visit(org.asyrinx.brownie.core.sql2.Select)
	 */
	public void visit(Select select) {
		result = new StringBuffer();
		work = new StringBuffer();
		select.getSelectFields().accept(this);
		if (work.length() > 0) {
			result.append("select ");
			if (select.isDistinct())
				result.append("distinct ");
			result.append(work);
		}
		work = new StringBuffer();
		select.getFromTables().accept(this);
		if (work.length() > 0) {
			if (result.length() > 0)
				result.append(" ");
			result.append("from ");
			result.append(work);
		}
		work = new StringBuffer();
		select.getWhereConditions().accept(this);
		if (work.length() > 0) {
			if (result.length() > 0)
				result.append(" ");
			result.append("where ");
			result.append(work);
		}
		work = new StringBuffer();
		select.getGroupByFields().accept(this);
		if (work.length() > 0) {
			if (result.length() > 0)
				result.append(" ");
			result.append("group by ");
			result.append(work);
		}
		work = new StringBuffer();
		select.getHavingConditions().accept(this);
		if (work.length() > 0) {
			if (result.length() > 0)
				result.append(" ");
			result.append("having ");
			result.append(work);
		}
		work = new StringBuffer();
		select.getOrderByFields().accept(this);
		if (work.length() > 0) {
			if (result.length() > 0)
				result.append(" ");
			result.append("order by ");
			result.append(work);
		}
	}

	protected String toString(Object value) {
		if (value instanceof String) {
			return StringUtils.toQuoted((String) value, '\'');
		} else if (value instanceof Character) {
			return StringUtils.toQuoted((Character) value + "", '\'');
		} else if (value.getClass().isArray()) {
			if (value.getClass().getComponentType().isPrimitive()) {
				return toString(
					IteratorUtils.arrayIterator(
						ArrayUtils.toObjectArray(value)));
			} else {
				return toString(IteratorUtils.arrayIterator((Object[]) value));
			}
		} else if (value instanceof Collection) {
			final Collection collection = (Collection) value;
			if (collection.isEmpty())
				return null;
			else
				return toString(((Collection) value).iterator());
		} else if (value instanceof Iterator) {
			return toString((Iterator) value);
		} else {
			return String.valueOf(value);
		}
	}

	protected String toString(Iterator iterator) {
		boolean isFirst = true;
		final StringBuffer buf = new StringBuffer();
		while (iterator.hasNext()) {
			if (isFirst)
				isFirst = false;
			else
				buf.append(", ");
			Object value = iterator.next();
			buf.append(toString(value));
		}
		final String res = buf.toString();
		if ("".equals(res))
			return null;
		else
			return res;
	}

	/**
	 * @see org.asyrinx.brownie.core.sql2.Visitor#visit(org.asyrinx.brownie.core.sql2.Condition)
	 */
	public void visit(Condition condition) {
		final String value = toString(condition.getValue());
		if (value == null)
			return;
		if (work.length() > 0)
			work.append(" ").append(condition.getConnection()).append(" ");
		if (StringUtils.isNotEmpty(condition.getFieldName()))
			work.append(condition.getFieldName()).append(" ");
		work.append(condition.getOperator()).append(" ");
		if (condition.getOperator() == Operator.IN)
			work.append("(");
		work.append(value);
		if (condition.getOperator() == Operator.IN)
			work.append(")");
	}

	/**
	 * @see org.asyrinx.brownie.core.sql2.Visitor#visit(org.asyrinx.brownie.core.sql2.Conditions)
	 */
	public void visit(Conditions conditions) {
		final Iterator iterator = conditions.iterator();
		while (iterator.hasNext()) {
			final Object object = iterator.next();
			if (object instanceof Condition) {
				((Condition) object).accept(this);
			} else if (object instanceof Conditions) {
				final StringBuffer workBakup = work;
				work = new StringBuffer();
				try {
					((Conditions) object).accept(this);
				} finally {
					if (work.length() > 0) {
						if (workBakup.length() > 0)
							workBakup.append(" ").append(
								conditions.getConnection()).append(
								" ");
						workBakup.append("(");
						workBakup.append(work);
						workBakup.append(")");
					}
					work = workBakup;
				}
			}
		}
	}

	/**
	 * @see org.asyrinx.brownie.core.sql2.Visitor#visit(org.asyrinx.brownie.core.sql2.Field)
	 */
	public void visit(Field field) {
		if (StringUtils.isNotEmpty(field.getFunctionName()))
			work.append(field.getFunctionName()).append("(");
		if (StringUtils.isNotEmpty(field.getTableAlias()))
			work.append(field.getTableAlias()).append(".");
		work.append(field.getFieldName());
		if (StringUtils.isNotEmpty(field.getFunctionName()))
			work.append(")");
		if (StringUtils.isNotEmpty(field.getAliasName()))
			work.append(" as ").append(field.getAliasName());
	}

	/**
	 * @see org.asyrinx.brownie.core.sql2.Visitor#visit(org.asyrinx.brownie.core.sql2.Fields)
	 */
	public void visit(Fields fields) {
		boolean isFirst = true;
		final Iterator iterator = fields.iterator();
		while (iterator.hasNext()) {
			if (!isFirst)
				work.append(", ");
			else
				isFirst = false;
			final Object object = iterator.next();
			if (object instanceof Field) {
				((Field) object).accept(this);
			} else if (object instanceof Fields) {
				((Fields) object).accept(this);
			}
		}
	}

	/**
	 * @see org.asyrinx.brownie.core.sql2.Visitor#visit(org.asyrinx.brownie.core.sql2.Table)
	 */
	public void visit(Table table) {
		if (StringUtils.isNotEmpty(table.getTablePrefix()))
			work.append(table.getTablePrefix()).append(".");
		work.append(table.getTableName());
		if (StringUtils.isNotEmpty(table.getTableAlias()))
			work.append(" as ").append(table.getTableAlias());
		if (StringUtils.isNotEmpty(table.getIndexName()))
			work.append("(INDEX ").append(table.getIndexName()).append(")");
	}

	/**
	 * @see org.asyrinx.brownie.core.sql2.Visitor#visit(org.asyrinx.brownie.core.sql2.Tables)
	 */
	public void visit(Tables tables) {
		boolean isFirst = true;
		final Iterator iterator = tables.iterator();
		while (iterator.hasNext()) {
			if (!isFirst)
				work.append(", ");
			else
				isFirst = false;
			final Object object = iterator.next();
			if (object instanceof Table) {
				((Table) object).accept(this);
			} else if (object instanceof Tables) {
				((Tables) object).accept(this);
			}
		}
	}

}
