/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/03/01
 */
package org.asyrinx.brownie.core.sql2;

import org.asyrinx.brownie.core.sql.Operator;

/**
 * @author akima
 */
public class Condition {

	/**
	 * 
	 */
	public Condition() {
		super();
	}

	public void accept(Visitor visitor) {
		visitor.visit(this);
	}

	public Operator getConnection() {
		return (getConditions() != null)
			? getConditions().getConnection()
			: Operator.NONE;
	}

	private Conditions conditions;
	private String fieldName;
	private Object value;
	private Operator operator;

	/**
	 * @return
	 */
	public String getFieldName() {
		return fieldName;
	}

	/**
	 * @return
	 */
	public Operator getOperator() {
		return operator;
	}

	/**
	 * @return
	 */
	public Object getValue() {
		return value;
	}

	/**
	 * @param string
	 */
	public void setFieldName(String string) {
		fieldName = string;
	}

	/**
	 * @param operator
	 */
	public void setOperator(Operator operator) {
		this.operator = operator;
	}

	/**
	 * @param object
	 */
	public void setValue(Object object) {
		value = object;
	}

	/**
	 * @return
	 */
	public Conditions getConditions() {
		return conditions;
	}

	/**
	 * @param conditions
	 */
	public void setConditions(Conditions conditions) {
		this.conditions = conditions;
	}

}
