/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
package org.asyrinx.brownie.core.util;

import java.util.Locale;

/**
 * N\NX 
 */
public final class Era {

	private final Locale locale;
	private final SimpleDateRange range;
	private final String firstLetter;
	private final String caption;
	private final String captionShort;

	/**
	 * constructor  
	 * @param locale
	 * @param caption
	 * @param captionShort
	 * @param firstLetter
	 * @param range
	 */
	public Era(
		Locale locale,
		String caption,
		String captionShort,
		String firstLetter,
		SimpleDateRange range) {
		this.locale = locale;
		this.firstLetter = firstLetter;
		this.caption = caption;
		this.captionShort = captionShort;
		this.range = range;
	}

	/**
	 * constructor  
	 * @param locale
	 * @param caption
	 * @param captionShort
	 * @param firstLetter
	 * @param range
	 */
	public Era(
		Locale locale,
		String caption,
		String captionShort,
		String firstLetter,
		DateRange range) {
		this(
			locale,
			caption,
			captionShort,
			firstLetter,
			new SimpleDateRange(range));
	}

	/**
	 * constructor  
	 * @param locale
	 * @param caption
	 * @param captionShort
	 * @param firstLetter
	 * @param begin
	 * @param end
	 */
	public Era(
		Locale locale,
		String caption,
		String captionShort,
		String firstLetter,
		SimpleDate begin,
		SimpleDate end) {
		this(
			locale,
			caption,
			captionShort,
			firstLetter,
			new SimpleDateRange(begin, end));
	}

	/**
	 * constructor  
	 * @param locale
	 * @param caption
	 * @param captionShort
	 * @param firstLetter
	 * @param beginYear
	 * @param beginMonth
	 * @param beginDay
	 * @param endYear
	 * @param endMonth
	 * @param endDay
	 */
	public Era(
		Locale locale,
		String caption,
		String captionShort,
		String firstLetter,
		int beginYear,
		int beginMonth,
		int beginDay,
		int endYear,
		int endMonth,
		int endDay) {
		this(
			locale,
			caption,
			captionShort,
			firstLetter,
			new SimpleDateRange(
				beginYear,
				beginMonth,
				beginDay,
				endYear,
				endMonth,
				endDay));
	}

	/**
	 * @return
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		return caption + "(" + range + ")";
	}

	/**
	 * 
	 * @param obj
	 * @return
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	public boolean equals(Object obj) {
		if (obj == null) {
			return false;
		} else if (obj instanceof Era) {
			return (obj == this);
		} else if (obj instanceof String) {
			return matchCaptions((String) obj);
		} else {
			return super.equals(obj);
		}
	}

	/**
	 * NɊY邩ǂԂB
	 * @param str
	 * @return
	 */
	public boolean matchCaptions(String str) {
		return (str.equals(caption))
			|| (str.equals(captionShort))
			|| (str.equals(firstLetter));
	}

	/**
	 * N\At@xbgȂǂ̓
	 * @return
	 */
	public String getFirstLetter() {
		return firstLetter;
	}

	/**
	 * N\
	 * @return
	 */
	public String getCaption() {
		return caption;
	}
	/**
	 * N\̗
	 * @return
	 */
	public String getCaptionShort() {
		return captionShort;
	}

	/**
	 * @return
	 */
	public SimpleDateRange getRange() {
		return range;
	}

	/**
	 * N̉\t
	 */
	public SimpleDate getBeginDate() {
		return this.range.getFrom();
	}

	/**
	 * N̍ŏI\t
	 * @return
	 */
	public SimpleDate getEndDate() {
		return this.range.getTo();
	}

	/**
	 * @return
	 */
	public int getBeginDay() {
		return this.getRange().getFromDay();
	}

	/**
	 * @return
	 */
	public int getBeginMonth() {
		return this.getRange().getFromMonth();
	}

	/**
	 * @return
	 */
	public int getBeginYear() {
		return this.getRange().getFromYear();
	}

	/**
	 * @return
	 */
	public int getEndDay() {
		return this.getRange().getToDay();
	}

	/**
	 * @return
	 */
	public int getEndMonth() {
		return this.getRange().getToMonth();
	}

	/**
	 * @return
	 */
	public int getEndYear() {
		return this.getRange().getToYear();
	}

	/** NɂN𐼗̔NɕϊB
	 */
	public int toAnnoDomini(int eraYear) {
		return getBeginYear() + eraYear - 1;
	}

	/**
	 * @return
	 */
	public Locale getLocale() {
		return locale;
	}

	/**
	 * tNŉNɓ̂Ԃ\bhB
	 * 
	 * @param d DOCUMENT ME!
	 * @param era DOCUMENT ME!
	 * @return DOCUMENT ME!
	 */
	public int getYearAt(SimpleDate d) {
		return d.getYear() - getBeginYear() + 1;
	}

}