/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
package org.asyrinx.brownie.core.util;

/**
 * @author akima
 */
public final class MathUtils {

	/**
	 * 
	 */
	private MathUtils() {
		super();
	}

	/**
	 * l̐10iŉ̂Ԃ܂B
	 * @param value
	 * @return
	 */
	public static int digitPlace(double value) {
		double work = Math.abs(value) / 10;
		int result = 1;
		while (work >= 1) {
			work /= 10;
			result++;
		}
		return result;
	}

	/**
	 * l̐10iŉ̂Ԃ܂B
	 * @param value
	 * @return
	 */
	public static int digitPlace(float value) {
		return digitPlace((double) value);
	}

	/**
	 * l̐10iŉ̂Ԃ܂B
	 * @param value
	 * @return
	 */
	public static int digitPlace(int value) {
		return digitPlace((double) value);
	}

	/**
	 * l̐10iŉ̂Ԃ܂B
	 * @param value
	 * @return
	 */
	public static int digitPlace(long value) {
		return digitPlace((double) value);
	}

	/**
	 * 10i̐lɑ΂Ďw肳ꂽ̐lԂ܂B
	 * @author akima
	 */
	public static int getDigitAt(double value, int place) {
		final double placeNumber =
			Math.pow(10, (place > 0) ? place : place + 1);
		double upper =
			new Double(value / placeNumber).longValue() * placeNumber;
		int result = new Double((value - upper) / placeNumber * 10).intValue();
		return result;
	}

	/**
	 * 10i̐lɑ΂Ďw肳ꂽ̐lԂ܂B
	 * @author akima
	 */
	public static int getDigitAt(long value, int place) {
		return getDigitAt((double) value, place);
	}

	/**
	 * 10i̐lɑ΂Ďw肳ꂽ̐lԂ܂B
	 * @author akima
	 */
	public static int getDigitAt(int value, int place) {
		return getDigitAt((double) value, place);
	}

	/**
	 * 10i̐lɑ΂Ďw肳ꂽ̐lԂ܂B
	 * @author akima
	 */
	public static int getDigitAt(float value, int place) {
		return getDigitAt((double) value, place);
	}

}
