/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/02/29
 */
package org.asyrinx.brownie.hibernate.wrapper;

import java.util.Map;

import net.sf.hibernate.HibernateException;
import net.sf.hibernate.engine.SessionFactoryImplementor;
import net.sf.hibernate.engine.TypedValue;
import net.sf.hibernate.expression.Criterion;

/**
 * @author akima
 */
public class CriterionWrapper implements Criterion {

	/**
	 * 
	 */
	public CriterionWrapper(Criterion wrapped) {
		super();
		this.wrapped = wrapped;
	}

	protected final Criterion wrapped;

	/**
	 * @param sessionFactory
	 * @param persistentClass
	 * @param aliasClasses
	 * @return
	 * @throws net.sf.hibernate.HibernateException
	 */
	public TypedValue[] getTypedValues(
		SessionFactoryImplementor sessionFactory,
		Class persistentClass,
		Map aliasClasses)
		throws HibernateException {
		return wrapped.getTypedValues(
			sessionFactory,
			persistentClass,
			aliasClasses);
	}

	/**
	 * @param sessionFactory
	 * @param persistentClass
	 * @param alias
	 * @param aliasClasses
	 * @return
	 * @throws net.sf.hibernate.HibernateException
	 */
	public String toSqlString(
		SessionFactoryImplementor sessionFactory,
		Class persistentClass,
		String alias,
		Map aliasClasses)
		throws HibernateException {
		return wrapped.toSqlString(
			sessionFactory,
			persistentClass,
			alias,
			aliasClasses);
	}

}
