/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/02/29
 */
package org.asyrinx.brownie.hibernate.wrapper;

import java.io.Serializable;
import java.sql.Connection;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

import net.sf.hibernate.Criteria;
import net.sf.hibernate.FlushMode;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.LockMode;
import net.sf.hibernate.Query;
import net.sf.hibernate.ReplicationMode;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import net.sf.hibernate.Transaction;
import net.sf.hibernate.type.Type;

/**
 * @author akima
 */
public class SessionWrapper implements Session {

	/**
	 * 
	 */
	public SessionWrapper(Session wrapped) {
		super();
		this.wrapped = wrapped;
	}

	protected final Session wrapped;

	/**
	 * @return
	 * @throws net.sf.hibernate.HibernateException
	 */
	public Transaction beginTransaction() throws HibernateException {
		return wrapped.beginTransaction();
	}

	/**
	 * @throws net.sf.hibernate.HibernateException
	 */
	public void cancelQuery() throws HibernateException {
		wrapped.cancelQuery();
	}

	/**
	 * 
	 */
	public void clear() {
		wrapped.clear();
	}

	/**
	 * @return
	 * @throws net.sf.hibernate.HibernateException
	 */
	public Connection close() throws HibernateException {
		return wrapped.close();
	}

	/**
	 * @return
	 * @throws net.sf.hibernate.HibernateException
	 */
	public Connection connection() throws HibernateException {
		return wrapped.connection();
	}

	/**
	 * @param object
	 * @return
	 */
	public boolean contains(Object object) {
		return wrapped.contains(object);
	}

	/**
	 * @param persistentClass
	 * @return
	 */
	public Criteria createCriteria(Class persistentClass) {
		return wrapped.createCriteria(persistentClass);
	}

	/**
	 * @param collection
	 * @param queryString
	 * @return
	 * @throws net.sf.hibernate.HibernateException
	 */
	public Query createFilter(Object collection, String queryString)
		throws HibernateException {
		return wrapped.createFilter(collection, queryString);
	}

	/**
	 * @param queryString
	 * @return
	 * @throws net.sf.hibernate.HibernateException
	 */
	public Query createQuery(String queryString) throws HibernateException {
		return wrapped.createQuery(queryString);
	}

	/**
	 * @param sql
	 * @param returnAlias
	 * @param returnClass
	 * @return
	 */
	public Query createSQLQuery(
		String sql,
		String returnAlias,
		Class returnClass) {
		return wrapped.createSQLQuery(sql, returnAlias, returnClass);
	}

	/**
	 * @param sql
	 * @param returnAliases
	 * @param returnClasses
	 * @return
	 */
	public Query createSQLQuery(
		String sql,
		String[] returnAliases,
		Class[] returnClasses) {
		return wrapped.createSQLQuery(sql, returnAliases, returnClasses);
	}

	/**
	 * @param object
	 * @throws net.sf.hibernate.HibernateException
	 */
	public void delete(Object object) throws HibernateException {
		wrapped.delete(object);
	}

	/**
	 * @param query
	 * @return
	 * @throws net.sf.hibernate.HibernateException
	 */
	public int delete(String query) throws HibernateException {
		return wrapped.delete(query);
	}

	/**
	 * @param query
	 * @param value
	 * @param type
	 * @return
	 * @throws net.sf.hibernate.HibernateException
	 */
	public int delete(String query, Object value, Type type)
		throws HibernateException {
		return wrapped.delete(query, value, type);
	}

	/**
	 * @param query
	 * @param values
	 * @param types
	 * @return
	 * @throws net.sf.hibernate.HibernateException
	 */
	public int delete(String query, Object[] values, Type[] types)
		throws HibernateException {
		return wrapped.delete(query, values, types);
	}

	/**
	 * @return
	 * @throws net.sf.hibernate.HibernateException
	 */
	public Connection disconnect() throws HibernateException {
		return wrapped.disconnect();
	}

	/**
	 * @param object
	 * @throws net.sf.hibernate.HibernateException
	 */
	public void evict(Object object) throws HibernateException {
		wrapped.evict(object);
	}

	/**
	 * @param collection
	 * @param filter
	 * @return
	 * @throws net.sf.hibernate.HibernateException
	 */
	public Collection filter(Object collection, String filter)
		throws HibernateException {
		return wrapped.filter(collection, filter);
	}

	/**
	 * @param collection
	 * @param filter
	 * @param value
	 * @param type
	 * @return
	 * @throws net.sf.hibernate.HibernateException
	 */
	public Collection filter(
		Object collection,
		String filter,
		Object value,
		Type type)
		throws HibernateException {
		return wrapped.filter(collection, filter, value, type);
	}

	/**
	 * @param collection
	 * @param filter
	 * @param values
	 * @param types
	 * @return
	 * @throws net.sf.hibernate.HibernateException
	 */
	public Collection filter(
		Object collection,
		String filter,
		Object[] values,
		Type[] types)
		throws HibernateException {
		return wrapped.filter(collection, filter, values, types);
	}

	/**
	 * @param query
	 * @return
	 * @throws net.sf.hibernate.HibernateException
	 */
	public List find(String query) throws HibernateException {
		return wrapped.find(query);
	}

	/**
	 * @param query
	 * @param value
	 * @param type
	 * @return
	 * @throws net.sf.hibernate.HibernateException
	 */
	public List find(String query, Object value, Type type)
		throws HibernateException {
		return wrapped.find(query, value, type);
	}

	/**
	 * @param query
	 * @param values
	 * @param types
	 * @return
	 * @throws net.sf.hibernate.HibernateException
	 */
	public List find(String query, Object[] values, Type[] types)
		throws HibernateException {
		return wrapped.find(query, values, types);
	}

	/**
	 * @throws net.sf.hibernate.HibernateException
	 */
	public void flush() throws HibernateException {
		wrapped.flush();
	}

	/**
	 * @param clazz
	 * @param id
	 * @return
	 * @throws net.sf.hibernate.HibernateException
	 */
	public Object get(Class clazz, Serializable id) throws HibernateException {
		return wrapped.get(clazz, id);
	}

	/**
	 * @param clazz
	 * @param id
	 * @param lockMode
	 * @return
	 * @throws net.sf.hibernate.HibernateException
	 */
	public Object get(Class clazz, Serializable id, LockMode lockMode)
		throws HibernateException {
		return wrapped.get(clazz, id, lockMode);
	}

	/**
	 * @param object
	 * @return
	 * @throws net.sf.hibernate.HibernateException
	 */
	public LockMode getCurrentLockMode(Object object)
		throws HibernateException {
		return wrapped.getCurrentLockMode(object);
	}

	/**
	 * @return
	 */
	public FlushMode getFlushMode() {
		return wrapped.getFlushMode();
	}

	/**
	 * @param object
	 * @return
	 * @throws net.sf.hibernate.HibernateException
	 */
	public Serializable getIdentifier(Object object)
		throws HibernateException {
		return wrapped.getIdentifier(object);
	}

	/**
	 * @param queryName
	 * @return
	 * @throws net.sf.hibernate.HibernateException
	 */
	public Query getNamedQuery(String queryName) throws HibernateException {
		return wrapped.getNamedQuery(queryName);
	}

	/**
	 * @return
	 */
	public SessionFactory getSessionFactory() {
		return wrapped.getSessionFactory();
	}

	/**
	 * @return
	 */
	public boolean isConnected() {
		return wrapped.isConnected();
	}

	/**
	 * @return
	 */
	public boolean isOpen() {
		return wrapped.isOpen();
	}

	/**
	 * @param query
	 * @return
	 * @throws net.sf.hibernate.HibernateException
	 */
	public Iterator iterate(String query) throws HibernateException {
		return wrapped.iterate(query);
	}

	/**
	 * @param query
	 * @param value
	 * @param type
	 * @return
	 * @throws net.sf.hibernate.HibernateException
	 */
	public Iterator iterate(String query, Object value, Type type)
		throws HibernateException {
		return wrapped.iterate(query, value, type);
	}

	/**
	 * @param query
	 * @param values
	 * @param types
	 * @return
	 * @throws net.sf.hibernate.HibernateException
	 */
	public Iterator iterate(String query, Object[] values, Type[] types)
		throws HibernateException {
		return wrapped.iterate(query, values, types);
	}

	/**
	 * @param theClass
	 * @param id
	 * @return
	 * @throws net.sf.hibernate.HibernateException
	 */
	public Object load(Class theClass, Serializable id)
		throws HibernateException {
		return wrapped.load(theClass, id);
	}

	/**
	 * @param theClass
	 * @param id
	 * @param lockMode
	 * @return
	 * @throws net.sf.hibernate.HibernateException
	 */
	public Object load(Class theClass, Serializable id, LockMode lockMode)
		throws HibernateException {
		return wrapped.load(theClass, id, lockMode);
	}

	/**
	 * @param object
	 * @param id
	 * @throws net.sf.hibernate.HibernateException
	 */
	public void load(Object object, Serializable id)
		throws HibernateException {
		wrapped.load(object, id);
	}

	/**
	 * @param object
	 * @param lockMode
	 * @throws net.sf.hibernate.HibernateException
	 */
	public void lock(Object object, LockMode lockMode)
		throws HibernateException {
		wrapped.lock(object, lockMode);
	}

	/**
	 * @throws net.sf.hibernate.HibernateException
	 */
	public void reconnect() throws HibernateException {
		wrapped.reconnect();
	}

	/**
	 * @param connection
	 * @throws net.sf.hibernate.HibernateException
	 */
	public void reconnect(Connection connection) throws HibernateException {
		wrapped.reconnect(connection);
	}

	/**
	 * @param object
	 * @throws net.sf.hibernate.HibernateException
	 */
	public void refresh(Object object) throws HibernateException {
		wrapped.refresh(object);
	}

	/**
	 * @param object
	 * @param lockMode
	 * @throws net.sf.hibernate.HibernateException
	 */
	public void refresh(Object object, LockMode lockMode)
		throws HibernateException {
		wrapped.refresh(object, lockMode);
	}

	/**
	 * @param object
	 * @param replicationMode
	 * @throws net.sf.hibernate.HibernateException
	 */
	public void replicate(Object object, ReplicationMode replicationMode)
		throws HibernateException {
		wrapped.replicate(object, replicationMode);
	}

	/**
	 * @param object
	 * @return
	 * @throws net.sf.hibernate.HibernateException
	 */
	public Serializable save(Object object) throws HibernateException {
		return wrapped.save(object);
	}

	/**
	 * @param object
	 * @param id
	 * @throws net.sf.hibernate.HibernateException
	 */
	public void save(Object object, Serializable id)
		throws HibernateException {
		wrapped.save(object, id);
	}

	/**
	 * @param object
	 * @throws net.sf.hibernate.HibernateException
	 */
	public void saveOrUpdate(Object object) throws HibernateException {
		wrapped.saveOrUpdate(object);
	}

	/**
	 * @param object
	 * @return
	 * @throws net.sf.hibernate.HibernateException
	 */
	public Object saveOrUpdateCopy(Object object) throws HibernateException {
		return wrapped.saveOrUpdateCopy(object);
	}

	/**
	 * @param object
	 * @param id
	 * @return
	 * @throws net.sf.hibernate.HibernateException
	 */
	public Object saveOrUpdateCopy(Object object, Serializable id)
		throws HibernateException {
		return wrapped.saveOrUpdateCopy(object, id);
	}

	/**
	 * @param flushMode
	 */
	public void setFlushMode(FlushMode flushMode) {
		wrapped.setFlushMode(flushMode);
	}

	/**
	 * @param object
	 * @throws net.sf.hibernate.HibernateException
	 */
	public void update(Object object) throws HibernateException {
		wrapped.update(object);
	}

	/**
	 * @param object
	 * @param id
	 * @throws net.sf.hibernate.HibernateException
	 */
	public void update(Object object, Serializable id)
		throws HibernateException {
		wrapped.update(object, id);
	}

}
