/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
package org.asyrinx.brownie.jdbc;

import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;

import org.asyrinx.brownie.jdbc.wrapper.ResultSetWrapper;
import org.asyrinx.brownie.core.lang.StringUtils;

/**
 * @author Akima
 */
public final class ResultSetFilter {

	/**
	 * 
	 */
	private ResultSetFilter() {
		super();
	}

	/**
	 * getStringœ镶trimtB^
	 * nullꍇAkɕϊB
	 * @param source
	 * @return
	 */
	public static ResultSet trim(ResultSet source) {
		return stringNullTrim(stringTrim(source));
	}

	/**
	 * getStringœ镶nullꍇkɕϊtB^
	 * @param source
	 * @return
	 */
	public static ResultSet stringNullTrim(ResultSet source) {
		return new ResultSetStringNullTrimFilter(source);
	}

	/**
	 * getStringœ镶trimstB^
	 * @param source
	 * @return
	 */
	public static ResultSet stringTrim(ResultSet source) {
		return new ResultSetStringTrimFilter(source);
	}

	/**
	 * getDateœtiDatej́A
	 * getTimestamp擾~bPʂ̓tɂȂ܂B
	 */
	public static ResultSet detailDate(ResultSet source) {
		return new ResultSetDetailDateFilter(source);
	}

	/**
	 * next\bhɂĐi߂郌R[hAw肵maxCount܂łɂȂ܂B
	 * maxCount0ȉȂtB^O܂B
	 * @param source
	 * @param maxCount
	 * @return
	 */
	public static ResultSet maxCount(ResultSet source, int maxCount) {
		return new ResultSetMaxCountFilter(source, maxCount);
	}

}

/**
 * getString\bh̖߂lɑ΂āAtrimstB^łB
 * ߂lnull̏ꍇɂ̓kԂ܂B
 * @author Akima
 */
class ResultSetStringTrimFilter extends ResultSetWrapper {
	/**
	 * Constructor for ResultSetStringTrimFilter.
	 * @param impl
	 */
	public ResultSetStringTrimFilter(ResultSet impl) {
		super(impl);
	}
	/**
	 * @see org.asyrinx.jdbc.ResultSetWrapper#getString(int)
	 */
	public String getString(int columnIndex) throws SQLException {
		final String result = super.getString(columnIndex);
		if (result != null)
			return result.trim();
		else
			return null;
	}
	/**
	 * @see org.asyrinx.jdbc.ResultSetWrapper#getString(String)
	 */
	public String getString(String columnName) throws SQLException {
		final String result = super.getString(columnName);
		if (result != null)
			return result.trim();
		else
			return null;
	}
}
/**
 * getString\bh̖߂lɑ΂āAtrimstB^łB
 * ߂lnull̏ꍇɂ̓kԂ܂B
 * @author Akima
 */
class ResultSetStringNullTrimFilter extends ResultSetWrapper {
	/**
	 * Constructor for ResultSetStringTrimFilter.
	 * @param impl
	 */
	public ResultSetStringNullTrimFilter(ResultSet impl) {
		super(impl);
	}
	/**
	 * @see org.asyrinx.jdbc.ResultSetWrapper#getString(int)
	 */
	public String getString(int columnIndex) throws SQLException {
		return StringUtils.nullTrim(super.getString(columnIndex));
	}
	/**
	 * @see org.asyrinx.jdbc.ResultSetWrapper#getString(String)
	 */
	public String getString(String columnName) throws SQLException {
		return StringUtils.nullTrim(super.getString(columnName));
	}
}
/**
 * getString\bh̖߂lɑ΂āAtrimstB^łB
 * ߂lnull̏ꍇɂ̓kԂ܂B
 * @author Akima
 */
class ResultSetDetailDateFilter extends ResultSetWrapper {
	/**
	 * Constructor for ResultSetStringTrimFilter.
	 * @param impl
	 */
	public ResultSetDetailDateFilter(ResultSet impl) {
		super(impl);
	}
	/**
	 * @see org.asyrinx.jdbc.ResultSetWrapper#getDate(int)
	 */
	public Date getDate(int columnIndex) throws SQLException {
		//return super.getDate(columnIndex);
		final Timestamp ts = super.getTimestamp(columnIndex);
		if (ts == null)
			return null;
		return new Date(ts.getTime());
	}
	/**
	 * @see org.asyrinx.jdbc.ResultSetWrapper#getDate(java.lang.String)
	 */
	public Date getDate(String columnName) throws SQLException {
		//return super.getDate(columnName);
		final Timestamp ts = super.getTimestamp(columnName);
		if (ts == null)
			return null;
		return new Date(ts.getTime());
	}

}
/**
 * <b>summary</b><br>
 * <br>
 * ݒ肳ꂽȏnextłȂResultSet̃tB^
 * <br>
 * <b>detail</b><br>
 * <br>
 * @author Akima
 * Created on 2003/05/23
 */
class ResultSetMaxCountFilter extends ResultSetWrapper {

	/**
	 * @param impl
	 */
	public ResultSetMaxCountFilter(ResultSet impl, int maxCount) {
		super(impl);
		this.maxCount = maxCount;

	}
	private final int maxCount;
	private int count = 0;

	/**
	 * @see org.asyrinx.jdbc.wrapper.ResultSetWrapper#next()
	 */
	public boolean next() throws SQLException {
		final boolean result = super.next();
		if (result)
			count++;
		// maxCount0ȉȂtB^OȂ
		if (maxCount < 1)
			return result;
		//ȂĂꍇ͉܂
		if (!result)
			return false;
		//͂܂ꍇɁAɏ傫falseԂĂ܂܂B
		return count <= maxCount;
	}

	/**
	 * @see org.asyrinx.jdbc.wrapper.ResultSetWrapper#previous()
	 */
	public boolean previous() throws SQLException {
		final boolean result = super.previous();
		if (result)
			count--;
		return result;
	}

}
