/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/03/01
 */
package org.asyrinx.brownie.jdbc.logger;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;

import org.asyrinx.brownie.core.collection.MapUtils;
import org.asyrinx.brownie.core.collection.StringKeyMap;
import org.asyrinx.brownie.core.log.CascadeNamedLog;

/**
 * @author akima
 */
public class LogCallableStatement
	extends LogPreparedStatement
	implements CallableStatement {
	/**
	 * @param wrapped
	 */
	public LogCallableStatement(
		CallableStatement wrapped,
		String sql,
		CascadeNamedLog parentLog) {
		super(wrapped, sql, parentLog);
		this.wrapped = wrapped;
	}
	private final CallableStatement wrapped;
	private final StringKeyMap parameters =
		MapUtils.toStringKeyMap(new HashMap());

	protected final void addParam(String paramName, Object value) {
		parameters.put(paramName, value);
	}
	protected String formatSql() {
		//p[^Ŏw肳ĂȂԍŎw肳ꂽ̂ƂSQLҏW
		if (this.parameters.isEmpty())
			return super.formatSql();
		else
			return replacer.execute(this.sql, this.parameters);
	}

	/**
	 * @throws java.sql.SQLException
	 */
	public void clearParameters() throws SQLException {
		super.clearParameters();
		parameters.clear();
	}

	/**
	 * @param i
	 * @return
	 * @throws java.sql.SQLException
	 */
	public Array getArray(int parameterIndex) throws SQLException {
		return wrapped.getArray(parameterIndex);
	}

	/**
	 * @param parameterName
	 * @return
	 * @throws java.sql.SQLException
	 */
	public Array getArray(String parameterName) throws SQLException {
		return wrapped.getArray(parameterName);
	}

	/**
	 * @param parameterIndex
	 * @return
	 * @throws java.sql.SQLException
	 */
	public BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
		return wrapped.getBigDecimal(parameterIndex);
	}

	/**
	 * @param parameterIndex
	 * @param scale
	 * @return
	 * @throws java.sql.SQLException
	 * @deprecated
	 */
	public BigDecimal getBigDecimal(int parameterIndex, int scale)
		throws SQLException {
		return wrapped.getBigDecimal(parameterIndex, scale);
	}

	/**
	 * @param parameterName
	 * @return
	 * @throws java.sql.SQLException
	 */
	public BigDecimal getBigDecimal(String parameterName) throws SQLException {
		return wrapped.getBigDecimal(parameterName);
	}

	/**
	 * @param i
	 * @return
	 * @throws java.sql.SQLException
	 */
	public Blob getBlob(int parameterIndex) throws SQLException {
		return wrapped.getBlob(parameterIndex);
	}

	/**
	 * @param parameterName
	 * @return
	 * @throws java.sql.SQLException
	 */
	public Blob getBlob(String parameterName) throws SQLException {
		return wrapped.getBlob(parameterName);
	}

	/**
	 * @param parameterIndex
	 * @return
	 * @throws java.sql.SQLException
	 */
	public boolean getBoolean(int parameterIndex) throws SQLException {
		return wrapped.getBoolean(parameterIndex);
	}

	/**
	 * @param parameterName
	 * @return
	 * @throws java.sql.SQLException
	 */
	public boolean getBoolean(String parameterName) throws SQLException {
		return wrapped.getBoolean(parameterName);
	}

	/**
	 * @param parameterIndex
	 * @return
	 * @throws java.sql.SQLException
	 */
	public byte getByte(int parameterIndex) throws SQLException {
		return wrapped.getByte(parameterIndex);
	}

	/**
	 * @param parameterName
	 * @return
	 * @throws java.sql.SQLException
	 */
	public byte getByte(String parameterName) throws SQLException {
		return wrapped.getByte(parameterName);
	}

	/**
	 * @param parameterIndex
	 * @return
	 * @throws java.sql.SQLException
	 */
	public byte[] getBytes(int parameterIndex) throws SQLException {
		return wrapped.getBytes(parameterIndex);
	}

	/**
	 * @param parameterName
	 * @return
	 * @throws java.sql.SQLException
	 */
	public byte[] getBytes(String parameterName) throws SQLException {
		return wrapped.getBytes(parameterName);
	}

	/**
	 * @param i
	 * @return
	 * @throws java.sql.SQLException
	 */
	public Clob getClob(int parameterIndex) throws SQLException {
		return wrapped.getClob(parameterIndex);
	}

	/**
	 * @param parameterName
	 * @return
	 * @throws java.sql.SQLException
	 */
	public Clob getClob(String parameterName) throws SQLException {
		return wrapped.getClob(parameterName);
	}

	/**
	 * @param parameterIndex
	 * @return
	 * @throws java.sql.SQLException
	 */
	public Date getDate(int parameterIndex) throws SQLException {
		return wrapped.getDate(parameterIndex);
	}

	/**
	 * @param parameterIndex
	 * @param cal
	 * @return
	 * @throws java.sql.SQLException
	 */
	public Date getDate(int parameterIndex, Calendar cal) throws SQLException {
		return wrapped.getDate(parameterIndex, cal);
	}

	/**
	 * @param parameterName
	 * @return
	 * @throws java.sql.SQLException
	 */
	public Date getDate(String parameterName) throws SQLException {
		return wrapped.getDate(parameterName);
	}

	/**
	 * @param parameterName
	 * @param cal
	 * @return
	 * @throws java.sql.SQLException
	 */
	public Date getDate(String parameterName, Calendar cal)
		throws SQLException {
		return wrapped.getDate(parameterName, cal);
	}

	/**
	 * @param parameterIndex
	 * @return
	 * @throws java.sql.SQLException
	 */
	public double getDouble(int parameterIndex) throws SQLException {
		return wrapped.getDouble(parameterIndex);
	}

	/**
	 * @param parameterName
	 * @return
	 * @throws java.sql.SQLException
	 */
	public double getDouble(String parameterName) throws SQLException {
		return wrapped.getDouble(parameterName);
	}

	/**
	 * @param parameterIndex
	 * @return
	 * @throws java.sql.SQLException
	 */
	public float getFloat(int parameterIndex) throws SQLException {
		return wrapped.getFloat(parameterIndex);
	}

	/**
	 * @param parameterName
	 * @return
	 * @throws java.sql.SQLException
	 */
	public float getFloat(String parameterName) throws SQLException {
		return wrapped.getFloat(parameterName);
	}

	/**
	 * @param parameterIndex
	 * @return
	 * @throws java.sql.SQLException
	 */
	public int getInt(int parameterIndex) throws SQLException {
		return wrapped.getInt(parameterIndex);
	}

	/**
	 * @param parameterName
	 * @return
	 * @throws java.sql.SQLException
	 */
	public int getInt(String parameterName) throws SQLException {
		return wrapped.getInt(parameterName);
	}

	/**
	 * @param parameterIndex
	 * @return
	 * @throws java.sql.SQLException
	 */
	public long getLong(int parameterIndex) throws SQLException {
		return wrapped.getLong(parameterIndex);
	}

	/**
	 * @param parameterName
	 * @return
	 * @throws java.sql.SQLException
	 */
	public long getLong(String parameterName) throws SQLException {
		return wrapped.getLong(parameterName);
	}

	/**
	 * @param parameterIndex
	 * @return
	 * @throws java.sql.SQLException
	 */
	public Object getObject(int parameterIndex) throws SQLException {
		return wrapped.getObject(parameterIndex);
	}

	/**
	 * @param i
	 * @param map
	 * @return
	 * @throws java.sql.SQLException
	 */
	public Object getObject(int parameterIndex, Map map) throws SQLException {
		return wrapped.getObject(parameterIndex, map);
	}

	/**
	 * @param parameterName
	 * @return
	 * @throws java.sql.SQLException
	 */
	public Object getObject(String parameterName) throws SQLException {
		return wrapped.getObject(parameterName);
	}

	/**
	 * @param parameterName
	 * @param map
	 * @return
	 * @throws java.sql.SQLException
	 */
	public Object getObject(String parameterName, Map map)
		throws SQLException {
		return wrapped.getObject(parameterName, map);
	}

	/**
	 * @param i
	 * @return
	 * @throws java.sql.SQLException
	 */
	public Ref getRef(int parameterIndex) throws SQLException {
		return wrapped.getRef(parameterIndex);
	}

	/**
	 * @param parameterName
	 * @return
	 * @throws java.sql.SQLException
	 */
	public Ref getRef(String parameterName) throws SQLException {
		return wrapped.getRef(parameterName);
	}

	/**
	 * @param parameterIndex
	 * @return
	 * @throws java.sql.SQLException
	 */
	public short getShort(int parameterIndex) throws SQLException {
		return wrapped.getShort(parameterIndex);
	}

	/**
	 * @param parameterName
	 * @return
	 * @throws java.sql.SQLException
	 */
	public short getShort(String parameterName) throws SQLException {
		return wrapped.getShort(parameterName);
	}

	/**
	 * @param parameterIndex
	 * @return
	 * @throws java.sql.SQLException
	 */
	public String getString(int parameterIndex) throws SQLException {
		return wrapped.getString(parameterIndex);
	}

	/**
	 * @param parameterName
	 * @return
	 * @throws java.sql.SQLException
	 */
	public String getString(String parameterName) throws SQLException {
		return wrapped.getString(parameterName);
	}

	/**
	 * @param parameterIndex
	 * @return
	 * @throws java.sql.SQLException
	 */
	public Time getTime(int parameterIndex) throws SQLException {
		return wrapped.getTime(parameterIndex);
	}

	/**
	 * @param parameterIndex
	 * @param cal
	 * @return
	 * @throws java.sql.SQLException
	 */
	public Time getTime(int parameterIndex, Calendar cal) throws SQLException {
		return wrapped.getTime(parameterIndex, cal);
	}

	/**
	 * @param parameterName
	 * @return
	 * @throws java.sql.SQLException
	 */
	public Time getTime(String parameterName) throws SQLException {
		return wrapped.getTime(parameterName);
	}

	/**
	 * @param parameterName
	 * @param cal
	 * @return
	 * @throws java.sql.SQLException
	 */
	public Time getTime(String parameterName, Calendar cal)
		throws SQLException {
		return wrapped.getTime(parameterName, cal);
	}

	/**
	 * @param parameterIndex
	 * @return
	 * @throws java.sql.SQLException
	 */
	public Timestamp getTimestamp(int parameterIndex) throws SQLException {
		return wrapped.getTimestamp(parameterIndex);
	}

	/**
	 * @param parameterIndex
	 * @param cal
	 * @return
	 * @throws java.sql.SQLException
	 */
	public Timestamp getTimestamp(int parameterIndex, Calendar cal)
		throws SQLException {
		return wrapped.getTimestamp(parameterIndex, cal);
	}

	/**
	 * @param parameterName
	 * @return
	 * @throws java.sql.SQLException
	 */
	public Timestamp getTimestamp(String parameterName) throws SQLException {
		return wrapped.getTimestamp(parameterName);
	}

	/**
	 * @param parameterName
	 * @param cal
	 * @return
	 * @throws java.sql.SQLException
	 */
	public Timestamp getTimestamp(String parameterName, Calendar cal)
		throws SQLException {
		return wrapped.getTimestamp(parameterName, cal);
	}

	/**
	 * @param parameterIndex
	 * @return
	 * @throws java.sql.SQLException
	 */
	public URL getURL(int parameterIndex) throws SQLException {
		return wrapped.getURL(parameterIndex);
	}

	/**
	 * @param parameterName
	 * @return
	 * @throws java.sql.SQLException
	 */
	public URL getURL(String parameterName) throws SQLException {
		return wrapped.getURL(parameterName);
	}

	/**
	 * @param parameterIndex
	 * @param sqlType
	 * @throws java.sql.SQLException
	 */
	public void registerOutParameter(int parameterIndex, int sqlType)
		throws SQLException {
		wrapped.registerOutParameter(parameterIndex, sqlType);
	}

	/**
	 * @param parameterIndex
	 * @param sqlType
	 * @param scale
	 * @throws java.sql.SQLException
	 */
	public void registerOutParameter(
		int parameterIndex,
		int sqlType,
		int scale)
		throws SQLException {
		wrapped.registerOutParameter(parameterIndex, sqlType, scale);
	}

	/**
	 * @param paramIndex
	 * @param sqlType
	 * @param typeName
	 * @throws java.sql.SQLException
	 */
	public void registerOutParameter(
		int paramIndex,
		int sqlType,
		String typeName)
		throws SQLException {
		wrapped.registerOutParameter(paramIndex, sqlType, typeName);
	}

	/**
	 * @param parameterName
	 * @param sqlType
	 * @throws java.sql.SQLException
	 */
	public void registerOutParameter(String parameterName, int sqlType)
		throws SQLException {
		wrapped.registerOutParameter(parameterName, sqlType);
	}

	/**
	 * @param parameterName
	 * @param sqlType
	 * @param scale
	 * @throws java.sql.SQLException
	 */
	public void registerOutParameter(
		String parameterName,
		int sqlType,
		int scale)
		throws SQLException {
		wrapped.registerOutParameter(parameterName, sqlType, scale);
	}

	/**
	 * @param parameterName
	 * @param sqlType
	 * @param typeName
	 * @throws java.sql.SQLException
	 */
	public void registerOutParameter(
		String parameterName,
		int sqlType,
		String typeName)
		throws SQLException {
		wrapped.registerOutParameter(parameterName, sqlType, typeName);
	}

	/**
	 * @param parameterName
	 * @param x
	 * @param length
	 * @throws java.sql.SQLException
	 */
	public void setAsciiStream(String parameterName, InputStream x, int length)
		throws SQLException {
		wrapped.setAsciiStream(parameterName, x, length);
		//addParam(parameterName, x);
	}

	/**
	 * @param parameterName
	 * @param x
	 * @throws java.sql.SQLException
	 */
	public void setBigDecimal(String parameterName, BigDecimal x)
		throws SQLException {
		wrapped.setBigDecimal(parameterName, x);
		addParam(parameterName, x);
	}

	/**
	 * @param parameterName
	 * @param x
	 * @param length
	 * @throws java.sql.SQLException
	 */
	public void setBinaryStream(
		String parameterName,
		InputStream x,
		int length)
		throws SQLException {
		wrapped.setBinaryStream(parameterName, x, length);
		//addParam(parameterName, x);
	}

	/**
	 * @param parameterName
	 * @param x
	 * @throws java.sql.SQLException
	 */
	public void setBoolean(String parameterName, boolean x)
		throws SQLException {
		wrapped.setBoolean(parameterName, x);
		addParam(parameterName, new Boolean(x));
	}

	/**
	 * @param parameterName
	 * @param x
	 * @throws java.sql.SQLException
	 */
	public void setByte(String parameterName, byte x) throws SQLException {
		wrapped.setByte(parameterName, x);
		addParam(parameterName, new Byte(x));
	}

	/**
	 * @param parameterName
	 * @param x
	 * @throws java.sql.SQLException
	 */
	public void setBytes(String parameterName, byte[] x) throws SQLException {
		wrapped.setBytes(parameterName, x);
		addParam(parameterName, x);
	}

	/**
	 * @param parameterName
	 * @param reader
	 * @param length
	 * @throws java.sql.SQLException
	 */
	public void setCharacterStream(
		String parameterName,
		Reader reader,
		int length)
		throws SQLException {
		wrapped.setCharacterStream(parameterName, reader, length);
		//addParam(parameterName, x);
	}

	/**
	 * @param parameterName
	 * @param x
	 * @throws java.sql.SQLException
	 */
	public void setDate(String parameterName, Date x) throws SQLException {
		wrapped.setDate(parameterName, x);
		addParam(parameterName, x);
	}

	/**
	 * @param parameterName
	 * @param x
	 * @param cal
	 * @throws java.sql.SQLException
	 */
	public void setDate(String parameterName, Date x, Calendar cal)
		throws SQLException {
		wrapped.setDate(parameterName, x, cal);
		addParam(parameterName, x);
	}

	/**
	 * @param parameterName
	 * @param x
	 * @throws java.sql.SQLException
	 */
	public void setDouble(String parameterName, double x) throws SQLException {
		wrapped.setDouble(parameterName, x);
		addParam(parameterName, new Double(x));
	}

	/**
	 * @param parameterName
	 * @param x
	 * @throws java.sql.SQLException
	 */
	public void setFloat(String parameterName, float x) throws SQLException {
		wrapped.setFloat(parameterName, x);
		addParam(parameterName, new Float(x));
	}

	/**
	 * @param parameterName
	 * @param x
	 * @throws java.sql.SQLException
	 */
	public void setInt(String parameterName, int x) throws SQLException {
		wrapped.setInt(parameterName, x);
		addParam(parameterName, new Integer(x));
	}

	/**
	 * @param parameterName
	 * @param x
	 * @throws java.sql.SQLException
	 */
	public void setLong(String parameterName, long x) throws SQLException {
		wrapped.setLong(parameterName, x);
		addParam(parameterName, new Long(x));
	}

	/**
	 * @param parameterName
	 * @param sqlType
	 * @throws java.sql.SQLException
	 */
	public void setNull(String parameterName, int sqlType)
		throws SQLException {
		wrapped.setNull(parameterName, sqlType);
		//addParam(parameterName, null);
	}

	/**
	 * @param parameterName
	 * @param sqlType
	 * @param typeName
	 * @throws java.sql.SQLException
	 */
	public void setNull(String parameterName, int sqlType, String typeName)
		throws SQLException {
		wrapped.setNull(parameterName, sqlType, typeName);
		//addParam(parameterName, null);
	}

	/**
	 * @param parameterName
	 * @param x
	 * @throws java.sql.SQLException
	 */
	public void setObject(String parameterName, Object x) throws SQLException {
		wrapped.setObject(parameterName, x);
		addParam(parameterName, x);
	}

	/**
	 * @param parameterName
	 * @param x
	 * @param targetSqlType
	 * @throws java.sql.SQLException
	 */
	public void setObject(String parameterName, Object x, int targetSqlType)
		throws SQLException {
		wrapped.setObject(parameterName, x, targetSqlType);
		addParam(parameterName, x);
	}

	/**
	 * @param parameterName
	 * @param x
	 * @param targetSqlType
	 * @param scale
	 * @throws java.sql.SQLException
	 */
	public void setObject(
		String parameterName,
		Object x,
		int targetSqlType,
		int scale)
		throws SQLException {
		wrapped.setObject(parameterName, x, targetSqlType, scale);
		addParam(parameterName, x);
	}

	/**
	 * @param parameterName
	 * @param x
	 * @throws java.sql.SQLException
	 */
	public void setShort(String parameterName, short x) throws SQLException {
		wrapped.setShort(parameterName, x);
		addParam(parameterName, new Short(x));
	}

	/**
	 * @param parameterName
	 * @param x
	 * @throws java.sql.SQLException
	 */
	public void setString(String parameterName, String x) throws SQLException {
		wrapped.setString(parameterName, x);
		addParam(parameterName, x);
	}

	/**
	 * @param parameterName
	 * @param x
	 * @throws java.sql.SQLException
	 */
	public void setTime(String parameterName, Time x) throws SQLException {
		wrapped.setTime(parameterName, x);
		addParam(parameterName, x);
	}

	/**
	 * @param parameterName
	 * @param x
	 * @param cal
	 * @throws java.sql.SQLException
	 */
	public void setTime(String parameterName, Time x, Calendar cal)
		throws SQLException {
		wrapped.setTime(parameterName, x, cal);
		addParam(parameterName, x);
	}

	/**
	 * @param parameterName
	 * @param x
	 * @throws java.sql.SQLException
	 */
	public void setTimestamp(String parameterName, Timestamp x)
		throws SQLException {
		wrapped.setTimestamp(parameterName, x);
		addParam(parameterName, x);
	}

	/**
	 * @param parameterName
	 * @param x
	 * @param cal
	 * @throws java.sql.SQLException
	 */
	public void setTimestamp(String parameterName, Timestamp x, Calendar cal)
		throws SQLException {
		wrapped.setTimestamp(parameterName, x, cal);
		addParam(parameterName, x);
	}

	/**
	 * @param parameterName
	 * @param val
	 * @throws java.sql.SQLException
	 */
	public void setURL(String parameterName, URL x) throws SQLException {
		wrapped.setURL(parameterName, x);
		addParam(parameterName, x);
	}

	/**
	 * @return
	 * @throws java.sql.SQLException
	 */
	public boolean wasNull() throws SQLException {
		return wrapped.wasNull();
	}

}
