/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/03/01
 */
package org.asyrinx.brownie.jdbc.logger;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;

import org.asyrinx.brownie.core.log.CascadeNamedLog;
import org.asyrinx.brownie.jdbc.wrapper.ConnectionWrapper;

/**
 * @author akima
 */
public class LogConnection extends ConnectionWrapper {

	/**
	 * @param wrapped
	 */
	public LogConnection(Connection wrapped, CascadeNamedLog parentLog) {
		super(wrapped);
		this.log = parentLog.subLog(this.wrapped);
	}

	private final CascadeNamedLog log;

	/* (non-Javadoc)
	 * @see java.sql.Connection#createStatement()
	 */
	public Statement createStatement() throws SQLException {
		return new LogStatement(super.createStatement(), log);
	}

	/* (non-Javadoc)
	 * @see java.sql.Connection#createStatement(int, int, int)
	 */
	public Statement createStatement(
		int resultSetType,
		int resultSetConcurrency,
		int resultSetHoldability)
		throws SQLException {
		return new LogStatement(
			super.createStatement(
				resultSetType,
				resultSetConcurrency,
				resultSetHoldability),
			log);
	}

	/* (non-Javadoc)
	 * @see java.sql.Connection#createStatement(int, int)
	 */
	public Statement createStatement(
		int resultSetType,
		int resultSetConcurrency)
		throws SQLException {
		return new LogStatement(
			super.createStatement(resultSetType, resultSetConcurrency),
			log);
	}

	/* (non-Javadoc)
	 * @see org.asyrinx.brownie.jdbc.logger.ConnectionWrapper#nativeSQL(java.lang.String)
	 */
	public String nativeSQL(String sql) throws SQLException {
		try {
			final String result = super.nativeSQL(sql);
			log.log(sql);
			return result;
		} catch (SQLException e) {
			log.log((Object) sql, e);
			throw e;
		}
	}

	/* (non-Javadoc)
	 * @see java.sql.Connection#prepareCall(java.lang.String, int, int, int)
	 */
	public CallableStatement prepareCall(
		String sql,
		int resultSetType,
		int resultSetConcurrency,
		int resultSetHoldability)
		throws SQLException {
		return new LogCallableStatement(
			super.prepareCall(
				sql,
				resultSetType,
				resultSetConcurrency,
				resultSetHoldability),
			sql,
			log);
	}

	/* (non-Javadoc)
	 * @see java.sql.Connection#prepareCall(java.lang.String, int, int)
	 */
	public CallableStatement prepareCall(
		String sql,
		int resultSetType,
		int resultSetConcurrency)
		throws SQLException {
		return new LogCallableStatement(
			super.prepareCall(sql, resultSetType, resultSetConcurrency),
			sql,
			log);
	}

	/* (non-Javadoc)
	 * @see java.sql.Connection#prepareCall(java.lang.String)
	 */
	public CallableStatement prepareCall(String sql) throws SQLException {
		return new LogCallableStatement(super.prepareCall(sql), sql, log);
	}

	/* (non-Javadoc)
	 * @see java.sql.Connection#prepareStatement(java.lang.String, int, int, int)
	 */
	public PreparedStatement prepareStatement(
		String sql,
		int resultSetType,
		int resultSetConcurrency,
		int resultSetHoldability)
		throws SQLException {
		return new LogPreparedStatement(
			super.prepareStatement(
				sql,
				resultSetType,
				resultSetConcurrency,
				resultSetHoldability),
			sql,
			log);
	}

	/* (non-Javadoc)
	 * @see java.sql.Connection#prepareStatement(java.lang.String, int, int)
	 */
	public PreparedStatement prepareStatement(
		String sql,
		int resultSetType,
		int resultSetConcurrency)
		throws SQLException {
		return new LogPreparedStatement(
			super.prepareStatement(sql, resultSetType, resultSetConcurrency),
			sql,
			log);
	}

	/* (non-Javadoc)
	 * @see java.sql.Connection#prepareStatement(java.lang.String, int)
	 */
	public PreparedStatement prepareStatement(
		String sql,
		int autoGeneratedKeys)
		throws SQLException {
		return new LogPreparedStatement(
			super.prepareStatement(sql, autoGeneratedKeys),
			sql,
			log);
	}

	/* (non-Javadoc)
	 * @see java.sql.Connection#prepareStatement(java.lang.String, int[])
	 */
	public PreparedStatement prepareStatement(String sql, int[] columnIndexes)
		throws SQLException {
		return new LogPreparedStatement(
			super.prepareStatement(sql, columnIndexes),
			sql,
			log);
	}

	/* (non-Javadoc)
	 * @see java.sql.Connection#prepareStatement(java.lang.String, java.lang.String[])
	 */
	public PreparedStatement prepareStatement(String sql, String[] columnNames)
		throws SQLException {
		return new LogPreparedStatement(
			super.prepareStatement(sql, columnNames),
			sql,
			log);
	}

	/* (non-Javadoc)
	 * @see java.sql.Connection#prepareStatement(java.lang.String)
	 */
	public PreparedStatement prepareStatement(String sql) throws SQLException {
		return new LogPreparedStatement(super.prepareStatement(sql), sql, log);
	}

}
