/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/02/15
 */
package org.asyrinx.brownie.jdbc.logger;

import java.sql.Connection;

import org.asyrinx.brownie.core.log.CascadeNamedLog;
import org.asyrinx.brownie.core.log.DispatchLog;

/**
 * Statement, PreparedStatement, CallableStatement̎s
 * sSQLOɏo͂tB^ConnectioñtB^łB<br>
 * gp@͒ʏConnectionƕς܂B<br>
 * createStatementŐStatement, PreparedStatement, CallableStatement
 * ɂĂlłB<br>
 * 
 * @see java.sql.Statement
 * @see java.sql.PreparedStatement
 * @see java.sql.CallableStatement
 * @see java.sql.Connection
 * @author akima
 */
public class LogConnectionFilter {

	/**
	 * OtB^ꂽRlNVԂ܂B<br>
	 * o͐̃O͎Iɐ܂B<br>
	 * Ȍo̓x"debug"łB<br>
	 * Ô̖connectioñNXłB
	 * <br>
	 * @see LogConnectionFilter#log(Connection, Log)
	 * @param connection ΏۂƂȂRlNV
	 */
	public static Connection log(Connection connection) {
		return log(connection, connection.getClass().getName());
	}

	/**
	 * OtB^ꂽRlNVԂ܂B<br>
	 * o͐̃O͎Iɐ܂B<br>
	 * Ȍo̓x"debug"łB<br>
	 * Ô̖connectioñNXłB
	 * <br>
	 * @see LogConnectionFilter#log(Connection, Log)
	 * @param connection ΏۂƂȂRlNV
	 */
	public static Connection log(Connection connection, String loggerName) {
		return log(connection, loggerName, DispatchLog.DEFAULT_LEVEL);
	}

	/**
	 * OtB^ꂽRlNVԂ܂B<br>
	 * o͐̃O͎Iɐ܂B<br>
	 * Ȍo̓x"debug"łB<br>
	 * Ô̖connectioñNXłB
	 * <br>
	 * @see LogConnectionFilter#log(Connection, Log)
	 * @param connection ΏۂƂȂRlNV
	 */
	public static Connection log(
		Connection connection,
		String loggerName,
		String logLevel) {
		return log(connection, new CascadeNamedLog(loggerName, logLevel));
	}

	/**
	 * OtB^ꂽRlNVԂ܂B<br>
	 * o͐̃O͎Iɐ܂B<br>
	 * Ȍo̓x"debug"łB<br>
	 * Ô̖connectioñNXłB
	 * <br>
	 * @see LogConnectionFilter#log(Connection, Log)
	 * @param connection ΏۂƂȂRlNV
	 * @param log o͐ƂȂ郍O
	 */
	public static Connection log(Connection connection, CascadeNamedLog log) {
		return new LogConnection(connection, log);
	}

}
