/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/03/01
 */
package org.asyrinx.brownie.jdbc.logger;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.asyrinx.brownie.core.log.CascadeNamedLog;
import org.asyrinx.brownie.jdbc.wrapper.StatementWrapper;

/**
 * @author akima
 */
public class LogStatement extends StatementWrapper {
	/**
	 * @param wrapped
	 */
	public LogStatement(Statement wrapped, CascadeNamedLog parentLog) {
		super(wrapped);
		this.log = parentLog.subLog(this.wrapped);
	}
	protected final CascadeNamedLog log;
	protected void log(Object message) {
		log.log(message);
	}
	protected void log(Object message, Throwable t) {
		log.log(message, t);
	}
	protected void logBatch(int[] results) {
		final StringBuffer result = new StringBuffer("batch executed:\n");
		final Iterator iterator = batches.iterator();
		int idx = 0;
		while (iterator.hasNext()) {
			if (idx > results.length - 1)
				break;
			String sql = (String) iterator.next();
			result.append(idx).append(" [").append(results[idx]).append("]");
			result.append(sql).append("\n");
			idx++;
		}
		log.log(result.toString());
	}

	protected void logBatch(Throwable t) {
		final StringBuffer result = new StringBuffer("batch executed:\n");
		final Iterator iterator = batches.iterator();
		int idx = 0;
		while (iterator.hasNext()) {
			String sql = (String) iterator.next();
			result.append(idx).append(" [?]");
			result.append(sql).append("\n");
			idx++;
		}
		log.log((Object) result.toString(), t);
	}

	protected final List batches = new ArrayList();

	/* (non-Javadoc)
	 * @see org.asyrinx.brownie.jdbc.logger.StatementWrapper#addBatch(java.lang.String)
	 */
	public void addBatch(String sql) throws SQLException {
		super.addBatch(sql);
		batches.add(sql);
	}
	/* (non-Javadoc)
	 * @see org.asyrinx.brownie.jdbc.logger.StatementWrapper#clearBatch()
	 */
	public void clearBatch() throws SQLException {
		super.clearBatch();
		batches.clear();
	}
	/* (non-Javadoc)
	 * @see org.asyrinx.brownie.jdbc.logger.StatementWrapper#execute(java.lang.String)
	 */
	public boolean execute(String sql) throws SQLException {
		try {
			boolean result = super.execute(sql);
			log(sql);
			return result;
		} catch (SQLException e) {
			log(sql, e);
			throw e;
		}
	}
	/* (non-Javadoc)
	 * @see org.asyrinx.brownie.jdbc.logger.StatementWrapper#execute(java.lang.String, int)
	 */
	public boolean execute(String sql, int autoGeneratedKeys)
		throws SQLException {
		try {
			boolean result = super.execute(sql, autoGeneratedKeys);
			log(sql);
			return result;
		} catch (SQLException e) {
			log(sql, e);
			throw e;
		}
	}
	/* (non-Javadoc)
	 * @see org.asyrinx.brownie.jdbc.logger.StatementWrapper#execute(java.lang.String, int[])
	 */
	public boolean execute(String sql, int[] columnIndexes)
		throws SQLException {
		try {
			boolean result = super.execute(sql, columnIndexes);
			log(sql);
			return result;
		} catch (SQLException e) {
			log(sql, e);
			throw e;
		}
	}
	/* (non-Javadoc)
	 * @see org.asyrinx.brownie.jdbc.logger.StatementWrapper#execute(java.lang.String, java.lang.String[])
	 */
	public boolean execute(String sql, String[] columnNames)
		throws SQLException {
		try {
			boolean result = super.execute(sql, columnNames);
			log(sql);
			return result;
		} catch (SQLException e) {
			log(sql, e);
			throw e;
		}
	}
	/* (non-Javadoc)
	 * @see org.asyrinx.brownie.jdbc.logger.StatementWrapper#executeBatch()
	 */
	public int[] executeBatch() throws SQLException {
		try {
			final int[] result = super.executeBatch();
			logBatch(result);
			return result;
		} catch (SQLException e) {
			logBatch(e);
			throw e;
		}
	}
	/* (non-Javadoc)
	 * @see org.asyrinx.brownie.jdbc.logger.StatementWrapper#executeQuery(java.lang.String)
	 */
	public ResultSet executeQuery(String sql) throws SQLException {
		try {
			final ResultSet result = super.executeQuery(sql);
			log(sql);
			return result;
		} catch (SQLException e) {
			log(sql, e);
			throw e;
		}
	}
	/* (non-Javadoc)
	 * @see org.asyrinx.brownie.jdbc.logger.StatementWrapper#executeUpdate(java.lang.String)
	 */
	public int executeUpdate(String sql) throws SQLException {
		try {
			final int result = super.executeUpdate(sql);
			log(sql);
			return result;
		} catch (SQLException e) {
			log(sql, e);
			throw e;
		}
	}
	/* (non-Javadoc)
	 * @see org.asyrinx.brownie.jdbc.logger.StatementWrapper#executeUpdate(java.lang.String, int)
	 */
	public int executeUpdate(String sql, int autoGeneratedKeys)
		throws SQLException {
		try {
			final int result = super.executeUpdate(sql, autoGeneratedKeys);
			log(sql);
			return result;
		} catch (SQLException e) {
			log(sql, e);
			throw e;
		}
	}
	/* (non-Javadoc)
	 * @see org.asyrinx.brownie.jdbc.logger.StatementWrapper#executeUpdate(java.lang.String, int[])
	 */
	public int executeUpdate(String sql, int[] columnIndexes)
		throws SQLException {
		try {
			final int result = super.executeUpdate(sql, columnIndexes);
			log(sql);
			return result;
		} catch (SQLException e) {
			log(sql, e);
			throw e;
		}
	}
	/* (non-Javadoc)
	 * @see org.asyrinx.brownie.jdbc.logger.StatementWrapper#executeUpdate(java.lang.String, java.lang.String[])
	 */
	public int executeUpdate(String sql, String[] columnNames)
		throws SQLException {
		try {
			final int result = super.executeUpdate(sql, columnNames);
			log(sql);
			return result;
		} catch (SQLException e) {
			log(sql, e);
			throw e;
		}
	}
}
