/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
package org.asyrinx.brownie.jdbc.wrapper;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

/**
 * @author Akima
 */
public class CallableStatementWrapper
	extends PreparedStatementWrapper
	implements CallableStatement {

	/**
	 * Constructor for CallableStatementWrapper.
	 * @param preparedStatement
	 */
	public CallableStatementWrapper(CallableStatement source) {
		super(source);
		this.source = source;
	}

	private final CallableStatement source;

	/**
	 * @param i
	 * @return
	 * @throws java.sql.SQLException
	 */
	public Array getArray(int i) throws SQLException {
		return source.getArray(i);
	}

	/**
	 * @param parameterName
	 * @return
	 * @throws java.sql.SQLException
	 */
	public Array getArray(String parameterName) throws SQLException {
		return source.getArray(parameterName);
	}

	/**
	 * @param parameterIndex
	 * @return
	 * @throws java.sql.SQLException
	 */
	public BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
		return source.getBigDecimal(parameterIndex);
	}

	/**
	 * @param parameterIndex
	 * @param scale
	 * @return
	 * @throws java.sql.SQLException
	 * @deprecated
	 */
	public BigDecimal getBigDecimal(int parameterIndex, int scale)
		throws SQLException {
		return null;
		//return preparedStatement.getBigDecimal(parameterIndex, scale);
	}

	/**
	 * @param parameterName
	 * @return
	 * @throws java.sql.SQLException
	 */
	public BigDecimal getBigDecimal(String parameterName) throws SQLException {
		return source.getBigDecimal(parameterName);
	}

	/**
	 * @param i
	 * @return
	 * @throws java.sql.SQLException
	 */
	public Blob getBlob(int i) throws SQLException {
		return source.getBlob(i);
	}

	/**
	 * @param parameterName
	 * @return
	 * @throws java.sql.SQLException
	 */
	public Blob getBlob(String parameterName) throws SQLException {
		return source.getBlob(parameterName);
	}

	/**
	 * @param parameterIndex
	 * @return
	 * @throws java.sql.SQLException
	 */
	public boolean getBoolean(int parameterIndex) throws SQLException {
		return source.getBoolean(parameterIndex);
	}

	/**
	 * @param parameterName
	 * @return
	 * @throws java.sql.SQLException
	 */
	public boolean getBoolean(String parameterName) throws SQLException {
		return source.getBoolean(parameterName);
	}

	/**
	 * @param parameterIndex
	 * @return
	 * @throws java.sql.SQLException
	 */
	public byte getByte(int parameterIndex) throws SQLException {
		return source.getByte(parameterIndex);
	}

	/**
	 * @param parameterName
	 * @return
	 * @throws java.sql.SQLException
	 */
	public byte getByte(String parameterName) throws SQLException {
		return source.getByte(parameterName);
	}

	/**
	 * @param parameterIndex
	 * @return
	 * @throws java.sql.SQLException
	 */
	public byte[] getBytes(int parameterIndex) throws SQLException {
		return source.getBytes(parameterIndex);
	}

	/**
	 * @param parameterName
	 * @return
	 * @throws java.sql.SQLException
	 */
	public byte[] getBytes(String parameterName) throws SQLException {
		return source.getBytes(parameterName);
	}

	/**
	 * @param i
	 * @return
	 * @throws java.sql.SQLException
	 */
	public Clob getClob(int i) throws SQLException {
		return source.getClob(i);
	}

	/**
	 * @param parameterName
	 * @return
	 * @throws java.sql.SQLException
	 */
	public Clob getClob(String parameterName) throws SQLException {
		return source.getClob(parameterName);
	}

	/**
	 * @param parameterIndex
	 * @return
	 * @throws java.sql.SQLException
	 */
	public Date getDate(int parameterIndex) throws SQLException {
		return source.getDate(parameterIndex);
	}

	/**
	 * @param parameterIndex
	 * @param cal
	 * @return
	 * @throws java.sql.SQLException
	 */
	public Date getDate(int parameterIndex, Calendar cal) throws SQLException {
		return source.getDate(parameterIndex, cal);
	}

	/**
	 * @param parameterName
	 * @return
	 * @throws java.sql.SQLException
	 */
	public Date getDate(String parameterName) throws SQLException {
		return source.getDate(parameterName);
	}

	/**
	 * @param parameterName
	 * @param cal
	 * @return
	 * @throws java.sql.SQLException
	 */
	public Date getDate(String parameterName, Calendar cal)
		throws SQLException {
		return source.getDate(parameterName, cal);
	}

	/**
	 * @param parameterIndex
	 * @return
	 * @throws java.sql.SQLException
	 */
	public double getDouble(int parameterIndex) throws SQLException {
		return source.getDouble(parameterIndex);
	}

	/**
	 * @param parameterName
	 * @return
	 * @throws java.sql.SQLException
	 */
	public double getDouble(String parameterName) throws SQLException {
		return source.getDouble(parameterName);
	}

	/**
	 * @param parameterIndex
	 * @return
	 * @throws java.sql.SQLException
	 */
	public float getFloat(int parameterIndex) throws SQLException {
		return source.getFloat(parameterIndex);
	}

	/**
	 * @param parameterName
	 * @return
	 * @throws java.sql.SQLException
	 */
	public float getFloat(String parameterName) throws SQLException {
		return source.getFloat(parameterName);
	}

	/**
	 * @param parameterIndex
	 * @return
	 * @throws java.sql.SQLException
	 */
	public int getInt(int parameterIndex) throws SQLException {
		return source.getInt(parameterIndex);
	}

	/**
	 * @param parameterName
	 * @return
	 * @throws java.sql.SQLException
	 */
	public int getInt(String parameterName) throws SQLException {
		return source.getInt(parameterName);
	}

	/**
	 * @param parameterIndex
	 * @return
	 * @throws java.sql.SQLException
	 */
	public long getLong(int parameterIndex) throws SQLException {
		return source.getLong(parameterIndex);
	}

	/**
	 * @param parameterName
	 * @return
	 * @throws java.sql.SQLException
	 */
	public long getLong(String parameterName) throws SQLException {
		return source.getLong(parameterName);
	}

	/**
	 * @param parameterIndex
	 * @return
	 * @throws java.sql.SQLException
	 */
	public Object getObject(int parameterIndex) throws SQLException {
		return source.getObject(parameterIndex);
	}

	/**
	 * @param i
	 * @param map
	 * @return
	 * @throws java.sql.SQLException
	 */
	public Object getObject(int i, Map map) throws SQLException {
		return source.getObject(i, map);
	}

	/**
	 * @param parameterName
	 * @return
	 * @throws java.sql.SQLException
	 */
	public Object getObject(String parameterName) throws SQLException {
		return source.getObject(parameterName);
	}

	/**
	 * @param parameterName
	 * @param map
	 * @return
	 * @throws java.sql.SQLException
	 */
	public Object getObject(String parameterName, Map map)
		throws SQLException {
		return source.getObject(parameterName, map);
	}

	/**
	 * @param i
	 * @return
	 * @throws java.sql.SQLException
	 */
	public Ref getRef(int i) throws SQLException {
		return source.getRef(i);
	}

	/**
	 * @param parameterName
	 * @return
	 * @throws java.sql.SQLException
	 */
	public Ref getRef(String parameterName) throws SQLException {
		return source.getRef(parameterName);
	}

	/**
	 * @param parameterIndex
	 * @return
	 * @throws java.sql.SQLException
	 */
	public short getShort(int parameterIndex) throws SQLException {
		return source.getShort(parameterIndex);
	}

	/**
	 * @param parameterName
	 * @return
	 * @throws java.sql.SQLException
	 */
	public short getShort(String parameterName) throws SQLException {
		return source.getShort(parameterName);
	}

	/**
	 * @param parameterIndex
	 * @return
	 * @throws java.sql.SQLException
	 */
	public String getString(int parameterIndex) throws SQLException {
		return source.getString(parameterIndex);
	}

	/**
	 * @param parameterName
	 * @return
	 * @throws java.sql.SQLException
	 */
	public String getString(String parameterName) throws SQLException {
		return source.getString(parameterName);
	}

	/**
	 * @param parameterIndex
	 * @return
	 * @throws java.sql.SQLException
	 */
	public Time getTime(int parameterIndex) throws SQLException {
		return source.getTime(parameterIndex);
	}

	/**
	 * @param parameterIndex
	 * @param cal
	 * @return
	 * @throws java.sql.SQLException
	 */
	public Time getTime(int parameterIndex, Calendar cal) throws SQLException {
		return source.getTime(parameterIndex, cal);
	}

	/**
	 * @param parameterName
	 * @return
	 * @throws java.sql.SQLException
	 */
	public Time getTime(String parameterName) throws SQLException {
		return source.getTime(parameterName);
	}

	/**
	 * @param parameterName
	 * @param cal
	 * @return
	 * @throws java.sql.SQLException
	 */
	public Time getTime(String parameterName, Calendar cal)
		throws SQLException {
		return source.getTime(parameterName, cal);
	}

	/**
	 * @param parameterIndex
	 * @return
	 * @throws java.sql.SQLException
	 */
	public Timestamp getTimestamp(int parameterIndex) throws SQLException {
		return source.getTimestamp(parameterIndex);
	}

	/**
	 * @param parameterIndex
	 * @param cal
	 * @return
	 * @throws java.sql.SQLException
	 */
	public Timestamp getTimestamp(int parameterIndex, Calendar cal)
		throws SQLException {
		return source.getTimestamp(parameterIndex, cal);
	}

	/**
	 * @param parameterName
	 * @return
	 * @throws java.sql.SQLException
	 */
	public Timestamp getTimestamp(String parameterName) throws SQLException {
		return source.getTimestamp(parameterName);
	}

	/**
	 * @param parameterName
	 * @param cal
	 * @return
	 * @throws java.sql.SQLException
	 */
	public Timestamp getTimestamp(String parameterName, Calendar cal)
		throws SQLException {
		return source.getTimestamp(parameterName, cal);
	}

	/**
	 * @param parameterIndex
	 * @return
	 * @throws java.sql.SQLException
	 */
	public URL getURL(int parameterIndex) throws SQLException {
		return source.getURL(parameterIndex);
	}

	/**
	 * @param parameterName
	 * @return
	 * @throws java.sql.SQLException
	 */
	public URL getURL(String parameterName) throws SQLException {
		return source.getURL(parameterName);
	}

	/**
	 * @param parameterIndex
	 * @param sqlType
	 * @throws java.sql.SQLException
	 */
	public void registerOutParameter(int parameterIndex, int sqlType)
		throws SQLException {
		source.registerOutParameter(parameterIndex, sqlType);
	}

	/**
	 * @param parameterIndex
	 * @param sqlType
	 * @param scale
	 * @throws java.sql.SQLException
	 */
	public void registerOutParameter(
		int parameterIndex,
		int sqlType,
		int scale)
		throws SQLException {
		source.registerOutParameter(parameterIndex, sqlType, scale);
	}

	/**
	 * @param paramIndex
	 * @param sqlType
	 * @param typeName
	 * @throws java.sql.SQLException
	 */
	public void registerOutParameter(
		int paramIndex,
		int sqlType,
		String typeName)
		throws SQLException {
		source.registerOutParameter(paramIndex, sqlType, typeName);
	}

	/**
	 * @param parameterName
	 * @param sqlType
	 * @throws java.sql.SQLException
	 */
	public void registerOutParameter(String parameterName, int sqlType)
		throws SQLException {
		source.registerOutParameter(parameterName, sqlType);
	}

	/**
	 * @param parameterName
	 * @param sqlType
	 * @param scale
	 * @throws java.sql.SQLException
	 */
	public void registerOutParameter(
		String parameterName,
		int sqlType,
		int scale)
		throws SQLException {
		source.registerOutParameter(parameterName, sqlType, scale);
	}

	/**
	 * @param parameterName
	 * @param sqlType
	 * @param typeName
	 * @throws java.sql.SQLException
	 */
	public void registerOutParameter(
		String parameterName,
		int sqlType,
		String typeName)
		throws SQLException {
		source.registerOutParameter(parameterName, sqlType, typeName);
	}

	/**
	 * @param parameterName
	 * @param x
	 * @param length
	 * @throws java.sql.SQLException
	 */
	public void setAsciiStream(String parameterName, InputStream x, int length)
		throws SQLException {
		source.setAsciiStream(parameterName, x, length);
	}

	/**
	 * @param parameterName
	 * @param x
	 * @throws java.sql.SQLException
	 */
	public void setBigDecimal(String parameterName, BigDecimal x)
		throws SQLException {
		source.setBigDecimal(parameterName, x);
	}

	/**
	 * @param parameterName
	 * @param x
	 * @param length
	 * @throws java.sql.SQLException
	 */
	public void setBinaryStream(
		String parameterName,
		InputStream x,
		int length)
		throws SQLException {
		source.setBinaryStream(parameterName, x, length);
	}

	/**
	 * @param parameterName
	 * @param x
	 * @throws java.sql.SQLException
	 */
	public void setBoolean(String parameterName, boolean x)
		throws SQLException {
		source.setBoolean(parameterName, x);
	}

	/**
	 * @param parameterName
	 * @param x
	 * @throws java.sql.SQLException
	 */
	public void setByte(String parameterName, byte x) throws SQLException {
		source.setByte(parameterName, x);
	}

	/**
	 * @param parameterName
	 * @param x
	 * @throws java.sql.SQLException
	 */
	public void setBytes(String parameterName, byte[] x) throws SQLException {
		source.setBytes(parameterName, x);
	}

	/**
	 * @param parameterName
	 * @param reader
	 * @param length
	 * @throws java.sql.SQLException
	 */
	public void setCharacterStream(
		String parameterName,
		Reader reader,
		int length)
		throws SQLException {
		source.setCharacterStream(parameterName, reader, length);
	}

	/**
	 * @param parameterName
	 * @param x
	 * @throws java.sql.SQLException
	 */
	public void setDate(String parameterName, Date x) throws SQLException {
		source.setDate(parameterName, x);
	}

	/**
	 * @param parameterName
	 * @param x
	 * @param cal
	 * @throws java.sql.SQLException
	 */
	public void setDate(String parameterName, Date x, Calendar cal)
		throws SQLException {
		source.setDate(parameterName, x, cal);
	}

	/**
	 * @param parameterName
	 * @param x
	 * @throws java.sql.SQLException
	 */
	public void setDouble(String parameterName, double x) throws SQLException {
		source.setDouble(parameterName, x);
	}

	/**
	 * @param parameterName
	 * @param x
	 * @throws java.sql.SQLException
	 */
	public void setFloat(String parameterName, float x) throws SQLException {
		source.setFloat(parameterName, x);
	}

	/**
	 * @param parameterName
	 * @param x
	 * @throws java.sql.SQLException
	 */
	public void setInt(String parameterName, int x) throws SQLException {
		source.setInt(parameterName, x);
	}

	/**
	 * @param parameterName
	 * @param x
	 * @throws java.sql.SQLException
	 */
	public void setLong(String parameterName, long x) throws SQLException {
		source.setLong(parameterName, x);
	}

	/**
	 * @param parameterName
	 * @param sqlType
	 * @throws java.sql.SQLException
	 */
	public void setNull(String parameterName, int sqlType)
		throws SQLException {
		source.setNull(parameterName, sqlType);
	}

	/**
	 * @param parameterName
	 * @param sqlType
	 * @param typeName
	 * @throws java.sql.SQLException
	 */
	public void setNull(String parameterName, int sqlType, String typeName)
		throws SQLException {
		source.setNull(parameterName, sqlType, typeName);
	}

	/**
	 * @param parameterName
	 * @param x
	 * @throws java.sql.SQLException
	 */
	public void setObject(String parameterName, Object x) throws SQLException {
		source.setObject(parameterName, x);
	}

	/**
	 * @param parameterName
	 * @param x
	 * @param targetSqlType
	 * @throws java.sql.SQLException
	 */
	public void setObject(String parameterName, Object x, int targetSqlType)
		throws SQLException {
		source.setObject(parameterName, x, targetSqlType);
	}

	/**
	 * @param parameterName
	 * @param x
	 * @param targetSqlType
	 * @param scale
	 * @throws java.sql.SQLException
	 */
	public void setObject(
		String parameterName,
		Object x,
		int targetSqlType,
		int scale)
		throws SQLException {
		source.setObject(parameterName, x, targetSqlType, scale);
	}

	/**
	 * @param parameterName
	 * @param x
	 * @throws java.sql.SQLException
	 */
	public void setShort(String parameterName, short x) throws SQLException {
		source.setShort(parameterName, x);
	}

	/**
	 * @param parameterName
	 * @param x
	 * @throws java.sql.SQLException
	 */
	public void setString(String parameterName, String x) throws SQLException {
		source.setString(parameterName, x);
	}

	/**
	 * @param parameterName
	 * @param x
	 * @throws java.sql.SQLException
	 */
	public void setTime(String parameterName, Time x) throws SQLException {
		source.setTime(parameterName, x);
	}

	/**
	 * @param parameterName
	 * @param x
	 * @param cal
	 * @throws java.sql.SQLException
	 */
	public void setTime(String parameterName, Time x, Calendar cal)
		throws SQLException {
		source.setTime(parameterName, x, cal);
	}

	/**
	 * @param parameterName
	 * @param x
	 * @throws java.sql.SQLException
	 */
	public void setTimestamp(String parameterName, Timestamp x)
		throws SQLException {
		source.setTimestamp(parameterName, x);
	}

	/**
	 * @param parameterName
	 * @param x
	 * @param cal
	 * @throws java.sql.SQLException
	 */
	public void setTimestamp(String parameterName, Timestamp x, Calendar cal)
		throws SQLException {
		source.setTimestamp(parameterName, x, cal);
	}

	/**
	 * @param parameterName
	 * @param val
	 * @throws java.sql.SQLException
	 */
	public void setURL(String parameterName, URL val) throws SQLException {
		source.setURL(parameterName, val);
	}

	/**
	 * @return
	 * @throws java.sql.SQLException
	 */
	public boolean wasNull() throws SQLException {
		return source.wasNull();
	}

}
