/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2003/12/11
 */
package org.asyrinx.brownie.jdbc.wrapper;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;

import javax.sql.DataSource;

/**
 * @author akima
 */
public class DataSourceWrapper implements DataSource {

	/**
	 * @param wrapped
	 */
	public DataSourceWrapper(DataSource dataSource) {
		super();
		this.source = dataSource;
	}

	/**
	 * @param wrapped
	 */
	public DataSourceWrapper() {
		this(null);
	}

	protected DataSource source;

	/**
	 * @return
	 * @throws java.sql.SQLException
	 */
	public Connection getConnection() throws SQLException {
		return source.getConnection();
	}

	/**
	 * @param username
	 * @param password
	 * @return
	 * @throws java.sql.SQLException
	 */
	public Connection getConnection(String username, String password)
		throws SQLException {
		return source.getConnection(username, password);
	}

	/**
	 * @return
	 * @throws java.sql.SQLException
	 */
	public int getLoginTimeout() throws SQLException {
		return source.getLoginTimeout();
	}

	/**
	 * @return
	 * @throws java.sql.SQLException
	 */
	public PrintWriter getLogWriter() throws SQLException {
		return source.getLogWriter();
	}

	/**
	 * @param seconds
	 * @throws java.sql.SQLException
	 */
	public void setLoginTimeout(int seconds) throws SQLException {
		source.setLoginTimeout(seconds);
	}

	/**
	 * @param out
	 * @throws java.sql.SQLException
	 */
	public void setLogWriter(PrintWriter out) throws SQLException {
		source.setLogWriter(out);
	}

	/**
	 * @return
	 */
	public DataSource getSource() {
		return source;
	}

	/**
	 * @param source
	 */
	public void setSource(DataSource source) {
		this.source = source;
	}

}
