/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2003/11/07
 */
package org.asyrinx.brownie.log.log4j.varia;

import org.apache.log4j.spi.Filter;
import org.apache.log4j.spi.LoggingEvent;

/**
 * @author akima
 */
public class LoggerNameMatchFilter extends Filter {

	/**
	 * 
	 */
	public LoggerNameMatchFilter() {
		super();
	}

	boolean acceptOnMatch = true;
	String stringToMatch;

	public void setStringToMatch(String s) {
		stringToMatch = s;
	}

	public String getStringToMatch() {
		return stringToMatch;
	}

	public void setAcceptOnMatch(boolean acceptOnMatch) {
		this.acceptOnMatch = acceptOnMatch;
	}

	public boolean getAcceptOnMatch() {
		return acceptOnMatch;
	}

	/**
	 * Returns {@link Filter#NEUTRAL} is there is no string match.
	 */
	public int decide(LoggingEvent event) {
		final String loggerName = event.getLoggerName();

		if (loggerName == null || stringToMatch == null)
			return Filter.NEUTRAL;

		if (loggerName.indexOf(stringToMatch) == -1) {
			return Filter.NEUTRAL;
		} else { // we've got a match
			if (acceptOnMatch) {
				return Filter.ACCEPT;
			} else {
				return Filter.DENY;
			}
		}
	}

}
