/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
package org.asyrinx.brownie.servlet;

import javax.servlet.http.HttpServletRequest;

import org.asyrinx.brownie.core.lang.StringUtils;

/**
 * @author Akima
 */
public final class ServletRequestFilter {

	/**
	 * 
	 */
	private ServletRequestFilter() {
		super();
	}

	/** p[^nullTrimtB^ */
	public static HttpServletRequest nullTrim(HttpServletRequest req) {
		return new HttpServletRequestNullTrimFilter(req);
	}

	/** p[^trimtB^ */
	public static HttpServletRequest stringTrim(HttpServletRequest req) {
		return new HttpServletRequestStringTrimFilter(req);
	}

	/** p[^trim  nullTrimtB^ */
	public static HttpServletRequest trim(HttpServletRequest req) {
		return nullTrim(stringTrim(req));
	}

}
/**
 * <b>summary</b><br>
 * <br>
 * p[^trimtB^
 * <br>
 * <b>detail</b><br>
 * <br>
 * @author Akima
 * Created on 2003/05/22
 */
class HttpServletRequestStringTrimFilter extends HttpServletRequestWrapper {
	public HttpServletRequestStringTrimFilter(HttpServletRequest impl) {
		super(impl);
	}

	public String getParameter(String name) {
		final String result = super.getParameter(name);
		if (result == null)
			return null;
		else
			return result.trim();
	}
}
/**
 * <b>summary</b><br>
 * <br>
 * p[^nullTrimtB^
 * <br>
 * <b>detail</b><br>
 * <br>
 * @author Akima
 * Created on 2003/05/22
 */
class HttpServletRequestNullTrimFilter extends HttpServletRequestWrapper {
	public HttpServletRequestNullTrimFilter(HttpServletRequest impl) {
		super(impl);
	}

	public String getParameter(String name) {
		return StringUtils.nullTrim(super.getParameter(name));
	}
}
