/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
package org.asyrinx.brownie.servlet;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;

import org.asyrinx.brownie.core.util.Wrapper;

/**
 * @author Akima
 */
public class ServletRequestWrapper extends Wrapper implements ServletRequest {

	/**
	 * Constructor for ServletRequestWrapper.
	 */
	public ServletRequestWrapper(ServletRequest servletRequest) {
		super(servletRequest);
		this.servletRequest = servletRequest;
	}

	protected final ServletRequest servletRequest;

	/**
	 * @see javax.servlet.ServletRequest#getAttribute(String)
	 */
	public Object getAttribute(String name) {
		return servletRequest.getAttribute(name);
	}

	/**
	 * @see javax.servlet.ServletRequest#getAttributeNames()
	 */
	public Enumeration getAttributeNames() {
		return servletRequest.getAttributeNames();
	}

	/**
	 * @see javax.servlet.ServletRequest#getCharacterEncoding()
	 */
	public String getCharacterEncoding() {
		return servletRequest.getCharacterEncoding();
	}

	/**
	 * @see javax.servlet.ServletRequest#getContentLength()
	 */
	public int getContentLength() {
		return servletRequest.getContentLength();
	}

	/**
	 * @see javax.servlet.ServletRequest#getContentType()
	 */
	public String getContentType() {
		return servletRequest.getContentType();
	}

	/**
	 * @see javax.servlet.ServletRequest#getInputStream()
	 */
	public ServletInputStream getInputStream() throws IOException {
		return servletRequest.getInputStream();
	}

	/**
	 * @see javax.servlet.ServletRequest#getParameter(String)
	 */
	public String getParameter(String name) {
		return servletRequest.getParameter(name);
	}

	/**
	 * @see javax.servlet.ServletRequest#getParameterNames()
	 */
	public Enumeration getParameterNames() {
		return servletRequest.getParameterNames();
	}

	/**
	 * @see javax.servlet.ServletRequest#getParameterValues(String)
	 */
	public String[] getParameterValues(String name) {
		return servletRequest.getParameterValues(name);
	}

	/**
	 * @see javax.servlet.ServletRequest#getProtocol()
	 */
	public String getProtocol() {
		return servletRequest.getProtocol();
	}

	/**
	 * @see javax.servlet.ServletRequest#getScheme()
	 */
	public String getScheme() {
		return servletRequest.getScheme();
	}

	/**
	 * @see javax.servlet.ServletRequest#getServerName()
	 */
	public String getServerName() {
		return servletRequest.getServerName();
	}

	/**
	 * @see javax.servlet.ServletRequest#getServerPort()
	 */
	public int getServerPort() {
		return servletRequest.getServerPort();
	}

	/**
	 * @see javax.servlet.ServletRequest#getReader()
	 */
	public BufferedReader getReader() throws IOException {
		return servletRequest.getReader();
	}

	/**
	 * @see javax.servlet.ServletRequest#getRemoteAddr()
	 */
	public String getRemoteAddr() {
		return servletRequest.getRemoteAddr();
	}

	/**
	 * @see javax.servlet.ServletRequest#getRemoteHost()
	 */
	public String getRemoteHost() {
		return servletRequest.getRemoteHost();
	}

	/**
	 * @see javax.servlet.ServletRequest#setAttribute(String, Object)
	 */
	public void setAttribute(String name, Object o) {
		servletRequest.setAttribute(name, o);
	}

	/**
	 * @see javax.servlet.ServletRequest#removeAttribute(String)
	 */
	public void removeAttribute(String name) {
		servletRequest.removeAttribute(name);
	}

	/**
	 * @see javax.servlet.ServletRequest#getLocale()
	 */
	public Locale getLocale() {
		return servletRequest.getLocale();
	}

	/**
	 * @see javax.servlet.ServletRequest#getLocales()
	 */
	public Enumeration getLocales() {
		return servletRequest.getLocales();
	}

	/**
	 * @see javax.servlet.ServletRequest#isSecure()
	 */
	public boolean isSecure() {
		return servletRequest.isSecure();
	}

	/**
	 * @see javax.servlet.ServletRequest#getRequestDispatcher(String)
	 */
	public RequestDispatcher getRequestDispatcher(String path) {
		return servletRequest.getRequestDispatcher(path);
	}

	//private final Logger log = LoggerFactory.getLog(this.getClass());

	/**
	 * @see javax.servlet.ServletRequest#getRealPath(String)
	 * @deprecated
	 */
	public String getRealPath(String path) {
		throw new UnsupportedOperationException("javax.servlet.ServletRequest#getRealPath(String) ͐܂Bjavax.servlet.ServletContext.getRealPath(java.lang.String)");
		//return servletRequest.getRealPath(path);
	}

	/**
	 * @return
	 */
	public Map getParameterMap() {
		return servletRequest.getParameterMap();
	}

	/**
	 * @param arg0
	 * @throws java.io.UnsupportedEncodingException
	 */
	public void setCharacterEncoding(String arg0)
		throws UnsupportedEncodingException {
		servletRequest.setCharacterEncoding(arg0);
	}

}
